/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.cosmetic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.NoFieldRecordLoadable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DisplayNameModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TrimModule
implements ModifierModule,
DisplayNameModifierHook,
ModifierRemovalHook {
    private static final String FORMAT_KEY = TConstruct.makeTranslationKey("modifier", "trim.formatted");
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.DISPLAY_NAME, ModifierHooks.REMOVE);
    public static final RecordLoadable<TrimModule> LOADER = new NoFieldRecordLoadable<TrimModule>(TrimModule::new);
    private final Map<String, Component> formattedCache = new HashMap<String, Component>();

    public RecordLoadable<TrimModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, Component name, @Nullable RegistryAccess access) {
        ModDataNBT modDataNBT = tool.getPersistentData();
        ModifierId id = entry.getId();
        String trimMaterial = modDataNBT.getString(TrimModule.materialKey(id));
        String trimPattern = modDataNBT.getString(TrimModule.patternKey(id));
        Component original = entry.getModifier().getDisplayName();
        if (trimMaterial.isEmpty() || trimPattern.isEmpty()) {
            return original;
        }
        String key = trimMaterial + "#" + trimPattern;
        Component formatted = this.formattedCache.get(key);
        if (formatted == null) {
            if (access == null) {
                return original;
            }
            formatted = original;
            TrimMaterial material = (TrimMaterial)access.m_175515_(Registries.f_266076_).m_7745_(ResourceLocation.m_135820_((String)trimMaterial));
            TrimPattern pattern = (TrimPattern)access.m_175515_(Registries.f_266063_).m_7745_(ResourceLocation.m_135820_((String)trimPattern));
            if (material != null && pattern != null) {
                formatted = Component.m_237110_((String)FORMAT_KEY, (Object[])new Object[]{pattern.f_265850_(), material.f_266021_()}).m_130948_(material.f_266021_().m_7383_());
            }
            this.formattedCache.put(trimMaterial, formatted);
        }
        return formatted;
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        ModifierId id = modifier.getId();
        tool.getPersistentData().remove(TrimModule.patternKey(id));
        tool.getPersistentData().remove(TrimModule.materialKey(id));
        return null;
    }

    public static ResourceLocation patternKey(ModifierId modifier) {
        return modifier.m_266382_("_pattern");
    }

    public static ResourceLocation materialKey(ModifierId modifier) {
        return modifier.m_266382_("_material");
    }
}

