/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public record RestoreLostHealthModule(LevelingValue percent, LevelingInt durabilityUsage, LevelingValue chance, IJsonPredicate<LivingEntity> attacker, IJsonPredicate<LivingEntity> defender, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ModifyDamageModifierHook,
TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MODIFY_DAMAGE, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<RestoreLostHealthModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("percentage", RestoreLostHealthModule::percent), (RecordField)LevelingInt.LOADABLE.requiredField("durability_usage", RestoreLostHealthModule::durabilityUsage), (RecordField)LevelingValue.LOADABLE.requiredField("chance", RestoreLostHealthModule::chance), (RecordField)LivingEntityPredicate.LOADER.defaultField("attacker", RestoreLostHealthModule::attacker), (RecordField)LivingEntityPredicate.LOADER.defaultField("defender", RestoreLostHealthModule::defender), ModifierCondition.TOOL_FIELD, RestoreLostHealthModule::new);

    @Override
    public RecordLoadable<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public Integer getPriority() {
        return 10;
    }

    @Override
    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity defender = context.getEntity();
        if (this.condition.matches(tool, modifier) && this.defender.matches((Object)defender) && TinkerPredicate.matches(this.attacker, source.m_7639_())) {
            int heal;
            float level = modifier.getEffectiveLevel();
            if (defender.m_217043_().m_188501_() < this.chance.compute(level) && (heal = (int)(this.percent.compute(level) * amount)) > 0) {
                defender.m_7292_(new MobEffectInstance(MobEffects.f_19605_, heal * 50));
                defender.m_9236_().m_6263_(null, defender.m_20185_(), defender.m_20186_(), defender.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                int durabilityUsage = this.durabilityUsage.compute(level);
                if (durabilityUsage > 0) {
                    ToolDamageUtil.damageAnimated(tool, durabilityUsage, defender, slotType, modifier.getId());
                }
            }
        }
        return amount;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float percent;
        if (TinkerPredicate.matchesInTooltip(this.defender, (LivingEntity)player, tooltipKey) && (percent = this.percent.compute(entry.getEffectiveLevel())) > 0.0f) {
            Modifier modifier = entry.getModifier();
            tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)(Util.PERCENT_FORMAT.format(percent) + " ")).m_7220_((Component)Component.m_237115_((String)(modifier.getTranslationKey() + ".restore")))));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder>
    implements LevelingValue.Builder<RestoreLostHealthModule> {
        private LevelingInt durabilityUsage = LevelingInt.eachLevel(1);
        private LevelingValue chance = LevelingValue.flat(0.15f);
        private IJsonPredicate<LivingEntity> attacker = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> defender = LivingEntityPredicate.ANY;

        private Builder() {
        }

        @Override
        public RestoreLostHealthModule amount(float flat, float eachLevel) {
            return new RestoreLostHealthModule(new LevelingValue(flat, eachLevel), this.durabilityUsage, this.chance, this.attacker, this.defender, this.condition);
        }

        public Builder durabilityUsage(LevelingInt durabilityUsage) {
            this.durabilityUsage = durabilityUsage;
            return this;
        }

        public Builder chance(LevelingValue chance) {
            this.chance = chance;
            return this;
        }

        public Builder attacker(IJsonPredicate<LivingEntity> attacker) {
            this.attacker = attacker;
            return this;
        }

        public Builder defender(IJsonPredicate<LivingEntity> defender) {
            this.defender = defender;
            return this;
        }
    }
}

