/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.armor;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolActionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.armor.ArmorWalkRadiusModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.MutableUseOnContext;
import slimeknights.tconstruct.library.utils.Util;

public record ToolActionWalkerTransformModule(ToolAction action, SoundEvent sound, LevelingValue radius, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ArmorWalkRadiusModule<MutableUseOnContext>,
ToolActionModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BOOT_WALK, ModifierHooks.TOOL_ACTION);
    public static final RecordLoadable<ToolActionWalkerTransformModule> LOADER = RecordLoadable.create((RecordField)Loadables.TOOL_ACTION.requiredField("tool_action", ToolActionWalkerTransformModule::action), (RecordField)Loadables.SOUND_EVENT.requiredField("sound", ToolActionWalkerTransformModule::sound), (RecordField)LevelingValue.LOADABLE.requiredField("radius", ToolActionWalkerTransformModule::radius), ModifierCondition.TOOL_FIELD, ToolActionWalkerTransformModule::new);

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float getRadius(IToolStackView tool, ModifierEntry modifier) {
        return this.radius.compute(modifier.getEffectiveLevel() + (float)tool.getVolatileData().getInt(IModifiable.EXPANDED));
    }

    @Override
    public boolean canPerformAction(IToolStackView tool, ModifierEntry modifier, ToolAction toolAction) {
        return this.condition.matches(tool, modifier) && toolAction == this.action;
    }

    @Override
    public void onWalk(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        if (this.condition.matches(tool, modifier)) {
            ArmorWalkRadiusModule.super.onWalk(tool, modifier, living, prevPos, newPos);
        }
    }

    @Override
    public MutableUseOnContext getContext(IToolStackView tool, ModifierEntry modifier, LivingEntity living, BlockPos prevPos, BlockPos newPos) {
        Player p;
        return new MutableUseOnContext(living.m_9236_(), living instanceof Player ? (p = (Player)living) : null, InteractionHand.MAIN_HAND, living.m_6844_(EquipmentSlot.FEET), Util.createTraceResult(newPos, Direction.UP, false));
    }

    @Override
    public boolean walkOn(IToolStackView tool, ModifierEntry entry, LivingEntity living, Level world, BlockPos target, BlockPos.MutableBlockPos mutable, MutableUseOnContext context) {
        BlockState state = world.m_8055_(target);
        if (state.m_247087_()) {
            mutable.m_122178_(target.m_123341_(), target.m_123342_() - 1, target.m_123343_());
            context.setOffsetPos((BlockPos)mutable);
            BlockState original = world.m_8055_((BlockPos)mutable);
            BlockState transformed = original.getToolModifiedState((UseOnContext)context, this.action, false);
            if (transformed != null) {
                world.m_7731_((BlockPos)mutable, transformed, 11);
                world.m_46961_(target, true);
                world.m_5594_(null, (BlockPos)mutable, this.sound, SoundSource.BLOCKS, 1.0f, 1.0f);
                ToolDamageUtil.damageAnimated(tool, 1, living, EquipmentSlot.FEET, entry.getId());
            }
        }
        return tool.isBroken();
    }

    public RecordLoadable<ToolActionWalkerTransformModule> getLoader() {
        return LOADER;
    }

    public static Builder builder(ToolAction action, SoundEvent sound) {
        return new Builder(action, sound);
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder>
    implements LevelingValue.Builder<ToolActionWalkerTransformModule> {
        private final ToolAction action;
        private final SoundEvent sound;

        @Override
        public ToolActionWalkerTransformModule amount(float flat, float eachLevel) {
            return new ToolActionWalkerTransformModule(this.action, this.sound, new LevelingValue(flat, eachLevel), this.condition);
        }

        private Builder(ToolAction action, SoundEvent sound) {
            this.action = action;
            this.sound = sound;
        }
    }
}

