/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingGetProjectileEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.mantle.util.CombatHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.EffectImmunityModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorStatModule;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableBowItem;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;
import slimeknights.tconstruct.shared.TinkerAttributes;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.logic.InteractionHandler;
import slimeknights.tconstruct.tools.modules.ranged.RestrictAngleModule;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModifierEvents {
    private static final TinkerDataCapability.TinkerDataKey<Float> PROJECTILE_EXPERIENCE = TConstruct.createKey("projectile_experience");
    public static final ResourceLocation EXPERIENCE = TConstruct.getResource("experience");
    public static final ResourceLocation SOULBOUND = TConstruct.getResource("soulbound");
    public static final ResourceLocation REFLECTING = TConstruct.getResource("reflecting");

    @SubscribeEvent
    static void onKnockback(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        Optional dataCap = entity.getCapability(TinkerDataCapability.CAPABILITY).resolve();
        double knockback = entity.m_21133_((Attribute)TinkerAttributes.KNOCKBACK_MULTIPLIER.get()) + (double)dataCap.map(data -> data.get(TinkerDataKeys.KNOCKBACK)).orElse(Float.valueOf(0.0f)).floatValue();
        if (knockback != 1.0) {
            event.setStrength((float)((double)event.getStrength() * knockback));
        }
        dataCap.ifPresent(data -> {
            int crystalbound = data.get(TinkerDataKeys.CRYSTALSTRIKE, 0);
            if (crystalbound > 0) {
                RestrictAngleModule.onKnockback(event, crystalbound);
            }
        });
    }

    @SubscribeEvent
    static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        double boost = entity.m_21133_((Attribute)TinkerAttributes.SAFE_FALL_DISTANCE.get()) + (double)ArmorStatModule.getStat((Entity)entity, TinkerDataKeys.JUMP_BOOST);
        if (boost != 0.0) {
            event.setDistance((float)Math.max((double)event.getDistance() - boost, 0.0));
        }
    }

    @SubscribeEvent
    public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        double boost = entity.m_21133_((Attribute)TinkerAttributes.JUMP_BOOST.get()) + (double)ArmorStatModule.getStat((Entity)entity, TinkerDataKeys.JUMP_BOOST);
        if (boost > 0.0) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, boost * 0.1, 0.0));
        }
    }

    @SubscribeEvent
    static void isPotionApplicable(MobEffectEvent.Applicable event) {
        event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
            if (((Multiset)data.computeIfAbsent(EffectImmunityModule.EFFECT_IMMUNITY)).contains((Object)event.getEffectInstance().m_19544_())) {
                event.setResult(Event.Result.DENY);
            }
        });
    }

    @SubscribeEvent
    static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity entity;
        TinkerDataCapability.Holder data;
        Projectile projectile;
        ModifierNBT modifiers;
        Entity entity2;
        DamageSource source = event.getSource();
        if (source != null && (entity2 = source.m_7640_()) instanceof Projectile && !(modifiers = EntityModifierCapability.getOrEmpty((Entity)(projectile = (Projectile)entity2))).isEmpty() && (data = TinkerDataCapability.getData(event.getEntity())) != null) {
            ModDataNBT projectileData = PersistentDataCapability.getOrWarn((Entity)projectile);
            data.put(PROJECTILE_EXPERIENCE, Float.valueOf(projectileData.getFloat(EXPERIENCE)));
        }
        if (!(entity = event.getEntity()).m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && entity instanceof Player && !((player = (Player)entity) instanceof FakePlayer)) {
            boolean soulBelt = ArmorLevelModule.getLevel((LivingEntity)player, TinkerDataKeys.SOUL_BELT) > 0;
            Inventory inventory = player.m_150109_();
            int hotbarSize = Inventory.m_36059_();
            for (int i = 0; i < hotbarSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !soulBelt && !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_("mantle_soulbound", i);
            }
            int totalSize = inventory.m_6643_();
            for (int i = hotbarSize; i < totalSize; ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41619_() || !ModifierUtil.checkVolatileFlag(stack, SOULBOUND)) continue;
                stack.m_41784_().m_128405_("mantle_soulbound", i);
            }
        }
    }

    @SubscribeEvent
    static void beforeBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        double bonus = player.m_21133_((Attribute)TinkerAttributes.EXPERIENCE_MULTIPLIER.get()) + (double)((float)ModifierUtil.getModifierLevel(player.m_21205_(), ModifierIds.experienced) * 0.5f) + (double)ArmorStatModule.getStat((Entity)player, TinkerDataKeys.EXPERIENCE);
        event.setExpToDrop((int)((double)event.getExpToDrop() * bonus));
    }

    @SubscribeEvent
    static void onExperienceDrop(LivingExperienceDropEvent event) {
        ToolStack tool;
        TinkerDataCapability.Holder data;
        Float projectileBoost;
        LivingEntity entity = event.getEntity();
        MobEffectInstance instance = entity.m_21124_((MobEffect)TinkerEffects.experienced.get());
        double multiplier = 1 + (instance != null ? instance.m_19564_() : 0);
        Player player = event.getAttackingPlayer();
        if (player != null) {
            multiplier += player.m_21133_((Attribute)TinkerAttributes.EXPERIENCE_MULTIPLIER.get()) + (double)ArmorStatModule.getStat((Entity)player, TinkerDataKeys.EXPERIENCE);
        }
        Float f = projectileBoost = (data = TinkerDataCapability.getData(entity)) != null ? data.get(PROJECTILE_EXPERIENCE) : null;
        if (projectileBoost != null) {
            multiplier += (double)projectileBoost.floatValue();
        } else if (player != null && (tool = Modifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player))) != null) {
            multiplier += (double)tool.getVolatileData().getFloat(EXPERIENCE);
        }
        event.setDroppedExperience((int)((double)event.getDroppedExperience() * multiplier));
    }

    @SubscribeEvent
    static void onCritical(CriticalHitEvent event) {
        Attribute attribute;
        Player living;
        double criticalBoost;
        if (event.getResult() != Event.Result.DENY && (criticalBoost = (living = event.getEntity()).m_21133_(attribute = (Attribute)TinkerAttributes.CRITICAL_DAMAGE.get()) - attribute.m_22082_() + (double)ArmorStatModule.getStat((Entity)living, TinkerDataKeys.CRITICAL_DAMAGE)) > 0.0) {
            boolean isCritical;
            boolean bl = isCritical = event.isVanillaCritical() || event.getResult() == Event.Result.ALLOW;
            if (!isCritical && TinkerPredicate.AIRBORNE.matches((Object)living)) {
                isCritical = true;
                event.setResult(Event.Result.ALLOW);
            }
            if (isCritical) {
                event.setDamageModifier((float)((double)event.getDamageModifier() + criticalBoost));
            }
        }
    }

    @SubscribeEvent
    static void onPotionStart(MobEffectEvent.Added event) {
        MobEffectInstance newEffect = event.getEffectInstance();
        if (!newEffect.getCurativeItems().isEmpty()) {
            boolean beneficial = newEffect.m_19544_().m_19486_();
            LivingEntity entity = event.getEntity();
            double multiplier = entity.m_21133_(beneficial ? (Attribute)TinkerAttributes.GOOD_EFFECT_DURATION.get() : (Attribute)TinkerAttributes.BAD_EFFECT_DURATION.get()) + (double)ArmorStatModule.getStat((Entity)entity, beneficial ? TinkerDataKeys.GOOD_EFFECT_DURATION : TinkerDataKeys.BAD_EFFECT_DURATION);
            if (multiplier != 1.0) {
                int duration = (int)((double)newEffect.m_19557_() * multiplier);
                if (duration < 0) {
                    duration = 0;
                }
                newEffect.f_19503_ = duration;
            }
        }
    }

    @SubscribeEvent
    static void bounceOnFall(LivingFallEvent event) {
        LivingEntity living = event.getEntity();
        if (living == null || living.m_20184_().f_82480_ > -0.3 && living.f_19789_ < 3.0f) {
            return;
        }
        if (living.m_21133_((Attribute)TinkerAttributes.BOUNCY.get()) < 1.0) {
            return;
        }
        if (living.m_20162_()) {
            event.setDamageMultiplier(0.5f);
            return;
        }
        event.setDamageMultiplier(0.0f);
        Vec3 motion = living.m_20184_();
        if (living instanceof ServerPlayer) {
            double gravity = living.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double time = Math.sqrt((double)living.f_19789_ / gravity);
            double velocity = gravity * time;
            living.m_20334_(motion.f_82479_ / (double)0.975f, velocity, motion.f_82481_ / (double)0.975f);
            living.f_19864_ = true;
            SlimeBounceHandler.addBounceHandler(living);
        } else {
            float factor = living.f_19789_ < 2.0f ? -0.7f : -0.9f;
            living.m_20334_(motion.f_82479_ / (double)0.975f, motion.f_82480_ * (double)factor, motion.f_82481_ / (double)0.975f);
            SlimeBounceHandler.addBounceHandler(living, living.m_20184_());
        }
        event.setDistance(0.0f);
        if (!living.m_9236_().f_46443_) {
            living.f_19812_ = true;
            event.setCanceled(true);
            living.m_6853_(false);
        }
        living.m_5496_(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
    }

    @SubscribeEvent
    static void onProjectile(LivingGetProjectileEvent event) {
        ItemStack bow = event.getProjectileWeaponItemStack();
        ItemStack ammo = event.getProjectileItemStack();
        if (bow.m_204117_(TinkerTags.Items.BALLISTAS) && ModifierUtil.checkVolatileFlag(bow, ModifiableBowItem.KEY_BALLISTA) && (ammo.m_41619_() || ammo.m_204117_(ItemTags.f_13161_))) {
            int flag = ModifierUtil.getPersistentInt(bow, ModifiableBowItem.KEY_BALLISTA, 0);
            if (flag <= 1) {
                LivingEntity entity = event.getEntity();
                ItemStack check = entity.m_21206_();
                if (check != bow && check.m_204117_(TinkerTags.Items.BALLISTA_AMMO)) {
                    event.setProjectileItemStack(check);
                }
                if ((check = entity.m_21205_()) != bow && check.m_204117_(TinkerTags.Items.BALLISTA_AMMO)) {
                    event.setProjectileItemStack(check);
                }
            } else if (flag == 2) {
                event.setProjectileItemStack(ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void projectileImpact(ProjectileImpactEvent event) {
        Entity entity;
        Entity entity2 = event.getEntity();
        Level level = entity2.m_9236_();
        Projectile projectile = event.getProjectile();
        HitResult hit = event.getRayTraceResult();
        if (hit.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hit).m_82443_()) instanceof LivingEntity) {
            ModifierEntry activeModifier;
            ToolStack tool;
            int reflectingTime;
            ItemStack stack;
            LivingEntity target = (LivingEntity)entity;
            if (!level.f_46443_ && !RegistryHelper.contains(TinkerTags.EntityTypes.REFLECTING_BLACKLIST, (EntityType)projectile.m_6095_()) && target != projectile.m_19749_() && target.m_6117_() && (stack = target.m_21211_()).m_204117_(TinkerTags.Items.SHIELDS) && (reflectingTime = (tool = ToolStack.from(stack)).getVolatileData().getInt(REFLECTING)) > 0 && (activeModifier = GeneralInteractionModifierHook.getActiveModifier(tool)) != ModifierEntry.EMPTY) {
                GeneralInteractionModifierHook hook = activeModifier.getHook(ModifierHooks.GENERAL_INTERACT);
                int time = hook.getUseDuration(tool, activeModifier) - target.m_21212_();
                if (hook.getUseAction(tool, activeModifier) == UseAnim.BLOCK && time >= 5 && time < reflectingTime && InteractionHandler.canBlock(target, projectile.m_20182_(), tool)) {
                    if (!RegistryHelper.contains(TinkerTags.EntityTypes.REFLECTING_PRESERVE_OWNER, (EntityType)projectile.m_6095_())) {
                        if (projectile instanceof AbstractArrow) {
                            AbstractArrow arrow = (AbstractArrow)projectile;
                            AbstractArrow.Pickup pickup = arrow.f_36705_;
                            arrow.m_5602_((Entity)target);
                            arrow.f_36705_ = pickup;
                        } else {
                            projectile.m_5602_((Entity)target);
                        }
                        projectile.f_37246_ = true;
                    }
                    Vec3 reboundAngle = target.m_20154_();
                    float velocity = ConditionalStatModifierHook.getModifiedStat(tool, target, ToolStats.VELOCITY) * 1.1f;
                    projectile.m_6686_(reboundAngle.f_82479_, reboundAngle.f_82480_, reboundAngle.f_82481_, velocity, ModifierUtil.getInaccuracy(tool, target));
                    if (projectile instanceof AbstractHurtingProjectile) {
                        AbstractHurtingProjectile hurting = (AbstractHurtingProjectile)projectile;
                        hurting.f_36813_ = reboundAngle.f_82479_ * 0.1;
                        hurting.f_36814_ = reboundAngle.f_82480_ * 0.1;
                        hurting.f_36815_ = reboundAngle.f_82481_ * 0.1;
                    }
                    if (target.m_6095_() == EntityType.f_20532_) {
                        TinkerNetwork.getInstance().sendVanillaPacket((Packet)new ClientboundSetEntityMotionPacket((Entity)projectile), (Entity)target);
                    }
                    level.m_5594_(null, target.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.5f + level.f_46441_.m_188501_() * 0.4f);
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                    if (ToolDamageUtil.damageAnimated(tool, 3, target)) {
                        target.m_5810_();
                        entity2.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + entity2.m_9236_().f_46441_.m_188501_() * 0.4f);
                    }
                }
            }
            if (TinkerEffects.needsEnderferenceOverride(target) && !projectile.m_6095_().m_204039_(TinkerTags.EntityTypes.ENDERFERENCE_ARROW_BLACKLIST) && projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (arrow.m_36796_() > 0) {
                    if (arrow.f_36701_ == null) {
                        arrow.f_36701_ = new IntOpenHashSet(5);
                    }
                    if (arrow.f_36702_ == null) {
                        arrow.f_36702_ = Lists.newArrayListWithCapacity((int)5);
                    }
                    if (arrow.f_36701_.size() >= arrow.m_36796_() + 1) {
                        arrow.m_146870_();
                        event.setCanceled(true);
                        return;
                    }
                    arrow.f_36701_.add(target.m_19879_());
                }
                int damage = Mth.m_14165_((double)Mth.m_14008_((double)(arrow.m_20184_().m_82553_() * arrow.m_36789_()), (double)0.0, (double)2.147483647E9));
                if (arrow.m_36792_()) {
                    damage = (int)Math.min((long)target.m_217043_().m_188503_(damage / 2 + 2) + (long)damage, Integer.MAX_VALUE);
                }
                Entity owner = arrow.m_19749_();
                DamageSource damageSource = CombatHelper.damageSource(TinkerDamageTypes.MELEE_ARROW, (Entity)projectile, (Entity)owner);
                LivingEntity livingOwner = ModifierUtil.asLiving(owner);
                if (livingOwner != null) {
                    livingOwner.m_21335_((Entity)target);
                }
                int remainingFire = target.m_20094_();
                if (arrow.m_6060_()) {
                    target.m_20254_(5);
                }
                if (target.m_6469_(damageSource, (float)damage)) {
                    Vec3 knockbackVec;
                    int knockback;
                    if (!level.f_46443_ && arrow.m_36796_() <= 0) {
                        target.m_21317_(target.m_21234_() + 1);
                    }
                    if ((knockback = arrow.m_150123_()) > 0 && (knockbackVec = arrow.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
                        target.m_5997_(knockbackVec.f_82479_, 0.1, knockbackVec.f_82481_);
                    }
                    if (!level.f_46443_ && livingOwner != null) {
                        EnchantmentHelper.m_44823_((LivingEntity)target, (Entity)livingOwner);
                        EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)target);
                    }
                    arrow.m_7761_(target);
                    if (!target.m_6084_() && arrow.f_36702_ != null) {
                        arrow.f_36702_.add(target);
                    }
                    if (!level.f_46443_ && arrow.m_36795_() && owner instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)owner;
                        if (arrow.f_36702_ != null) {
                            CriteriaTriggers.f_10556_.m_46871_(player, (Collection)arrow.f_36702_);
                        } else if (!target.m_6084_()) {
                            CriteriaTriggers.f_10556_.m_46871_(player, List.of(target));
                        }
                    }
                    arrow.m_5496_(arrow.f_36700_, 1.0f, 1.2f / (target.m_217043_().m_188501_() * 0.2f + 0.9f));
                    if (arrow.m_36796_() <= 0) {
                        arrow.m_146870_();
                    }
                } else {
                    target.m_7311_(remainingFire);
                    arrow.m_20256_(arrow.m_20184_().m_82490_(-0.1));
                    arrow.m_146922_(arrow.m_146908_() + 180.0f);
                    arrow.f_19859_ += 180.0f;
                    if (!level.f_46443_ && arrow.m_20184_().m_82556_() < 1.0E-7) {
                        if (arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                            arrow.m_5552_(arrow.m_7941_(), 0.1f);
                        }
                        arrow.m_146870_();
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    static void onTeleport(EntityTeleportEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21023_((MobEffect)TinkerEffects.enderference.get())) {
            event.setCanceled(true);
        }
    }
}

