/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import slimeknights.mantle.util.CombatHelper;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithKnockback;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerTools;

public class CombatFishingHook
extends FishingHook
implements ProjectileWithKnockback,
ProjectileWithPower {
    private static final float PI = (float)Math.PI;
    private static final float GRAPPLE_STRENGTH = 0.58f;
    private static final EntityDataAccessor<Byte> GRAPPLE = SynchedEntityData.m_135353_(CombatFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> COLLECTING = SynchedEntityData.m_135353_(CombatFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<MaterialVariantId> MATERIAL = SynchedEntityData.m_135353_(CombatFishingHook.class, MaterialVariantId.DATA_ACCESSOR);
    private float power = 0.0f;
    private float knockback = 0.0f;
    private double impactVelocity = 1.0;
    private BlockState wallState = null;
    private static final String TAG_MATERIAL = "material";

    public CombatFishingHook(EntityType<? extends FishingHook> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public CombatFishingHook(Player player, Level level, int luck, int lure, float velocity, float inaccuracy) {
        super((EntityType)TinkerTools.fishingHook.get(), level, luck, lure);
        this.m_5602_((Entity)player);
        float xRot = player.m_146909_();
        float yRot = player.m_146908_();
        float yAngle = -yRot * (float)Math.PI / 180.0f - (float)Math.PI;
        float dz = Mth.m_14089_((float)yAngle);
        float dx = Mth.m_14031_((float)yAngle);
        this.m_7678_(player.m_20185_() - (double)dx * 0.3, player.m_20188_(), player.m_20189_() - (double)dz * 0.3, yRot, xRot);
        float xAngle = -xRot * ((float)Math.PI / 180);
        float yCos = -Mth.m_14089_((float)xAngle);
        float ySin = Mth.m_14031_((float)xAngle);
        Vec3 deltaMovement = new Vec3((double)(-dx), (double)Mth.m_14036_((float)(-ySin / yCos), (float)-5.0f, (float)5.0f), (double)(-dz));
        double length = deltaMovement.m_82553_();
        double maxRandom = 0.03 * (double)inaccuracy * (double)inaccuracy;
        deltaMovement = deltaMovement.m_82542_((double)velocity / length + this.f_19796_.m_216328_(0.5, maxRandom), (double)velocity / length + this.f_19796_.m_216328_(0.5, maxRandom), (double)velocity / length + this.f_19796_.m_216328_(0.5, maxRandom));
        this.m_20256_(deltaMovement);
        this.m_146922_((float)(Mth.m_14136_((double)deltaMovement.f_82479_, (double)deltaMovement.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)deltaMovement.f_82480_, (double)deltaMovement.m_165924_()) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GRAPPLE, (Object)((byte)GrappleType.NONE.ordinal()));
        this.f_19804_.m_135372_(COLLECTING, (Object)false);
        this.f_19804_.m_135372_(MATERIAL, (Object)IMaterial.UNKNOWN_ID);
    }

    public MaterialVariantId getMaterial() {
        return (MaterialVariantId)this.f_19804_.m_135370_(MATERIAL);
    }

    public void setMaterial(MaterialVariantId material) {
        this.f_19804_.m_135381_(MATERIAL, (Object)material);
    }

    @Override
    public void addKnockback(float amount) {
        this.knockback += amount;
    }

    public void setGrapple(GrappleType type) {
        this.f_19804_.m_135381_(GRAPPLE, (Object)((byte)type.ordinal()));
    }

    public void setCollecting() {
        this.f_19804_.m_135381_(COLLECTING, (Object)true);
    }

    private boolean isGrapple() {
        return ((Byte)this.f_19804_.m_135370_(GRAPPLE)).byteValue() != GrappleType.NONE.ordinal();
    }

    private boolean isDrill() {
        return ((Byte)this.f_19804_.m_135370_(GRAPPLE)).byteValue() == GrappleType.DRILL.ordinal();
    }

    private boolean isCollecting() {
        return (Boolean)this.f_19804_.m_135370_(COLLECTING);
    }

    @Override
    public float getDamage() {
        double velocity = this.m_37170_() != null ? this.impactVelocity : this.m_20184_().m_82553_();
        return (float)Mth.m_14165_((double)Mth.m_14008_((double)(velocity * (double)this.power * 15.0), (double)0.0, (double)2.147483647E9)) / 10.0f;
    }

    private void damageRod() {
        Entity entity;
        if (!this.m_9236_().f_46443_ && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack stack = living.m_21205_();
            InteractionHand hand = InteractionHand.MAIN_HAND;
            if (!stack.canPerformAction(ToolActions.FISHING_ROD_CAST)) {
                stack = living.m_21206_();
                if (!stack.canPerformAction(ToolActions.FISHING_ROD_CAST)) {
                    return;
                }
                hand = InteractionHand.OFF_HAND;
            }
            if (stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                ToolDamageUtil.damageAnimated((IToolStackView)ToolStack.from(stack), 1, living, hand);
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        this.impactVelocity = this.m_20184_().m_82553_();
        this.damageRod();
    }

    protected boolean m_5603_(Entity target) {
        return super.m_5603_(target) || target.m_6084_() && this.isCollecting() && (target.m_6095_().m_204039_(TinkerTags.EntityTypes.COLLECTABLES) || target instanceof AbstractArrow);
    }

    protected void m_150155_(Entity target) {
        Entity owner = this.m_19749_();
        if (owner != null) {
            boolean collectable;
            boolean bl = collectable = target.m_6095_().m_204039_(TinkerTags.EntityTypes.COLLECTABLES) || target instanceof ItemEntity || target instanceof AbstractArrow;
            if (collectable && this.isCollecting() && owner instanceof Player) {
                Player player = (Player)owner;
                target.m_6123_(player);
                if (target.m_213877_()) {
                    return;
                }
                if (target.m_6095_().m_204039_(TinkerTags.EntityTypes.DISCARDABLE_COLLECTABLES)) {
                    target.m_146870_();
                    return;
                }
            }
            if (this.power > 0.0f && !collectable) {
                float oldHealth;
                if (owner instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)owner;
                    living.m_21335_(target);
                }
                float damage = this.getDamage();
                DamageSource source = CombatHelper.damageSource(TinkerDamageTypes.FISHING_HOOK, (Entity)this, (Entity)owner);
                LivingEntity targetLiving = ToolAttackUtil.getLivingEntity(target);
                AttributeInstance knockback = ToolAttackUtil.disableKnockback(targetLiving);
                float f = oldHealth = targetLiving != null ? targetLiving.m_21223_() : 0.0f;
                if (target.m_6469_(source, damage) && !this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    ItemStack stack;
                    LivingEntity ownerLiving = (LivingEntity)owner;
                    if (targetLiving != null) {
                        EnchantmentHelper.m_44823_((LivingEntity)targetLiving, (Entity)owner);
                    }
                    if (((stack = ownerLiving.m_21205_()).canPerformAction(ToolActions.FISHING_ROD_CAST) || (stack = ownerLiving.m_21206_()).canPerformAction(ToolActions.FISHING_ROD_CAST)) && stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                        float damageDealt = damage;
                        if (targetLiving != null) {
                            damageDealt = oldHealth - targetLiving.m_21223_();
                        }
                        ToolStack tool = ToolStack.from(stack);
                        for (ModifierEntry modifier : tool.getModifiers()) {
                            modifier.getHook(ModifierHooks.LAUNCHER_HIT).onLauncherHitEntity(tool, modifier, (Projectile)this, ownerLiving, target, targetLiving, damageDealt);
                        }
                    }
                }
                ToolAttackUtil.enableKnockback(knockback);
            }
            Vec3 knockback = new Vec3(owner.m_20185_() - this.m_20185_(), owner.m_20186_() - this.m_20186_(), owner.m_20189_() - this.m_20189_());
            float scale = 0.1f;
            if (this.knockback > 0.0f) {
                scale = (float)((double)scale + (double)(this.knockback * 0.25f) * Mth.m_264555_((double)knockback.m_82556_()));
            }
            target.m_20256_(target.m_20184_().m_82549_(knockback.m_82490_((double)scale)));
            if (this.isDrill()) {
                this.pullGrapple(owner);
            }
        }
    }

    private void pullGrapple(Entity owner) {
        Player player;
        Vec3 knockback = new Vec3(this.m_20185_() - owner.m_20185_(), this.m_20186_() - owner.m_20186_(), this.m_20189_() - owner.m_20189_());
        knockback = knockback.m_82490_((double)0.58f * Math.pow(knockback.m_82556_(), -0.25));
        owner.m_5997_(knockback.f_82479_, knockback.f_82480_, knockback.f_82481_);
        if (this.isDrill() && owner instanceof Player) {
            player = (Player)owner;
            player.m_204079_(20);
        }
        if (owner instanceof ServerPlayer) {
            player = (ServerPlayer)owner;
            player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(player.m_19879_(), player.m_20184_()));
        }
    }

    public int m_37156_(ItemStack stack) {
        Entity owner = this.m_19749_();
        if (this.m_20096_() || this.wallState != null) {
            if (owner != null && this.isGrapple()) {
                this.pullGrapple(owner);
            }
            if (owner instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)owner;
                if (stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
                    ToolStack tool = ToolStack.from(stack);
                    BlockPos pos = this.m_20183_();
                    for (ModifierEntry entry : tool.getModifiers()) {
                        entry.getHook(ModifierHooks.LAUNCHER_HIT).onLauncherHitBlock(tool, entry, (Projectile)this, living, pos);
                    }
                }
            }
            return Mth.m_14045_((int)super.m_37156_(stack), (int)2, (int)3);
        }
        return Math.min(super.m_37156_(stack), 3);
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (this.isGrapple()) {
            this.m_6853_(true);
            this.wallState = this.m_9236_().m_8055_(result.m_82425_());
            Vec3 hit = result.m_82450_();
            Vec3 offset = hit.m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.m_20256_(offset);
            this.m_20343_(hit.f_82479_, hit.f_82480_, hit.f_82481_);
        }
    }

    private boolean shouldFall() {
        return this.wallState != null && this.m_9236_().m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    private void startFalling() {
        this.wallState = null;
        Vec3 velocity = this.m_20184_();
        this.m_20256_(velocity.m_82542_((double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)(this.f_19796_.m_188501_() * 0.2f)));
        this.f_37103_ = 0;
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        if (type == MoverType.SELF && this.wallState != null) {
            if (this.wallState != this.m_9236_().m_8055_(this.m_20183_()) && this.shouldFall()) {
                this.startFalling();
            } else {
                return;
            }
        }
        super.m_6478_(type, pos);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void m_8119_() {
        int oldLife = this.f_37103_;
        super.m_8119_();
        if (this.wallState != null && !this.m_9236_().f_46443_) {
            this.f_37103_ = oldLife + 1;
            if (this.f_37103_ >= 1200) {
                this.m_146870_();
            }
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_(TAG_MATERIAL, this.getMaterial().toString());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_(TAG_MATERIAL)) {
            this.setMaterial(Objects.requireNonNullElse(MaterialVariantId.tryParse(tag.m_128461_(TAG_MATERIAL)), IMaterial.UNKNOWN_ID));
        }
    }

    @Override
    public float getPower() {
        return this.power;
    }

    @Override
    public void setPower(float power) {
        this.power = power;
    }

    public static enum GrappleType {
        NONE,
        DASH,
        DRILL;

    }
}

