/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.shared.TinkerEffects;

public class ToolAttackUtil {
    private static final UUID SLOT_MAINHAND_ATTRIBUTE = UUID.fromString("fd666e50-d2cc-11eb-b8bc-0242ac130003");
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final AttributeModifier ANTI_KNOCKBACK_MODIFIER = new AttributeModifier("tconstruct.anti_knockback", 1.0, AttributeModifier.Operation.ADDITION);
    @Deprecated(forRemoval=true)
    public static final DoubleSupplier NO_COOLDOWN = () -> 1.0;

    public static float getToolAttribute(IToolStackView tool, LivingEntity holder, Attribute attribute, float toolValue) {
        AttributeInstance instance = holder.m_21051_(attribute);
        if (instance == null) {
            return (float)holder.m_21172_(attribute);
        }
        ItemStack mainStack = holder.m_21205_();
        Collection mainModifiers = List.of();
        if (!mainStack.m_41619_()) {
            mainModifiers = mainStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)attribute);
            for (AttributeModifier modifier2 : mainModifiers) {
                instance.m_22130_(modifier2);
            }
        } else if (attribute == Attributes.f_22281_) {
            instance.m_22120_(Item.f_41374_);
        }
        ArrayList<AttributeModifier> slotAttributes = new ArrayList<AttributeModifier>();
        if (toolValue != 0.0f) {
            slotAttributes.add(new AttributeModifier(SLOT_MAINHAND_ATTRIBUTE, "tconstruct.tool.slot_mainhand_attribute", (double)toolValue, AttributeModifier.Operation.ADDITION));
        }
        BiConsumer<Attribute, AttributeModifier> attributeConsumer = (check, modifier) -> {
            if (check == attribute) {
                slotAttributes.add((AttributeModifier)modifier);
            }
        };
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(ModifierHooks.ATTRIBUTES).addAttributes(tool, entry, EquipmentSlot.MAINHAND, attributeConsumer);
        }
        for (AttributeModifier modifier3 : slotAttributes) {
            instance.m_22118_(modifier3);
        }
        float value = (float)instance.m_22135_();
        for (AttributeModifier modifier4 : slotAttributes) {
            instance.m_22130_(modifier4);
        }
        for (AttributeModifier modifier4 : mainModifiers) {
            instance.m_22118_(modifier4);
        }
        return value;
    }

    public static float getCriticalModifier(LivingEntity attacker, @Nullable Player attackerPlayer, Entity target, @Nullable LivingEntity livingTarget, boolean fullyCharged) {
        float criticalModifier;
        boolean isCritical = fullyCharged && attacker.f_19789_ > 0.0f && !attacker.m_20096_() && !attacker.m_6147_() && !attacker.m_20069_() && !attacker.m_21023_(MobEffects.f_19610_) && !attacker.m_20159_() && livingTarget != null && !attacker.m_20142_();
        float f = criticalModifier = isCritical ? 1.5f : 1.0f;
        if (attackerPlayer != null) {
            CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)attackerPlayer, (Entity)target, (boolean)isCritical, (float)criticalModifier);
            criticalModifier = hitResult != null ? hitResult.getDamageModifier() : 1.0f;
        }
        return criticalModifier;
    }

    @Nullable
    public static LivingEntity getLivingEntity(Entity entity) {
        LivingEntity living;
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            entity = part.getParent();
        }
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public static boolean attackEntity(ItemStack stack, Player attacker, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(ToolStack.from(stack), attacker, targetEntity);
    }

    public static boolean attackEntity(IToolStackView tool, Player attacker, Entity target) {
        if (!ToolAttackUtil.canPerformAttack(tool)) {
            return false;
        }
        if (ToolAttackUtil.isAttackable((LivingEntity)attacker, target)) {
            ToolAttackUtil.performAttack(tool, ToolAttackContext.attacker(attacker).target(target).defaultCooldown().applyAttributes().build());
        }
        return true;
    }

    public static boolean canPerformAttack(IToolStackView tool) {
        return !tool.isBroken() && tool.hasTag(TinkerTags.Items.MELEE);
    }

    public static boolean isAttackable(LivingEntity attacker, Entity target) {
        return !attacker.m_9236_().f_46443_ && target.m_6097_() && !target.m_7313_((Entity)attacker);
    }

    public static boolean performAttack(IToolStackView tool, ToolAttackContext context) {
        Player attackerPlayer;
        float baseKnockback;
        float cooldown;
        float baseDamage;
        float damage = baseDamage = context.getBaseDamage();
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            damage = entry.getHook(ModifierHooks.MELEE_DAMAGE).getMeleeDamage(tool, entry, context, baseDamage, damage);
        }
        if (damage <= 0.0f) {
            return false;
        }
        boolean isMagic = damage > baseDamage;
        float criticalModifier = context.getCriticalModifier();
        if (criticalModifier != 1.0f) {
            damage += baseDamage * (criticalModifier - 1.0f);
        }
        if ((cooldown = context.getCooldown()) < 1.0f) {
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        float oldHealth = 0.0f;
        LivingEntity targetLiving = context.getLivingTarget();
        if (targetLiving != null) {
            oldHealth = targetLiving.m_21223_();
        }
        float knockback = baseKnockback = context.getBaseKnockback();
        for (ModifierEntry entry : modifiers) {
            knockback = entry.getHook(ModifierHooks.MELEE_HIT).beforeMeleeHit(tool, entry, context, damage, baseKnockback, knockback);
        }
        LivingEntity attackerLiving = context.getAttacker();
        EquipmentSlot sourceSlot = context.getSlotType();
        ModifierLootingHandler.setLootingSlot(attackerLiving, sourceSlot);
        AttributeInstance knockbackModifier = null;
        if (knockback < 0.4f) {
            knockbackModifier = ToolAttackUtil.disableKnockback(targetLiving);
        } else if (targetLiving != null) {
            knockback -= 0.4f;
        }
        Entity targetEntity = context.getTarget();
        boolean didHit = targetEntity.m_6469_(context.makeDamageSource(), damage);
        ModifierLootingHandler.setLootingSlot(attackerLiving, EquipmentSlot.MAINHAND);
        ToolAttackUtil.enableKnockback(knockbackModifier);
        Level level = context.getLevel();
        boolean isExtraAttack = context.isExtraAttack();
        Projectile projectile = context.getProjectile();
        if (!didHit || projectile != null && !TinkerEffects.canHitWithProjectile(targetLiving)) {
            if (!isExtraAttack) {
                level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), SoundEvents.f_12315_, attackerLiving.m_5720_(), 1.0f, 1.0f);
            }
            for (ModifierEntry entry : modifiers) {
                entry.getHook(ModifierHooks.MELEE_HIT).failedMeleeHit(tool, entry, context, damage);
            }
            return false;
        }
        tool.getHook(ToolHooks.MELEE_HIT).afterMeleeHit(tool, context, damage);
        float damageDealt = damage;
        if (targetLiving != null) {
            damageDealt = oldHealth - targetLiving.m_21223_();
        }
        if (knockback > 0.0f) {
            if (targetLiving != null) {
                targetLiving.m_147240_((double)knockback, (double)Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180)))));
            } else {
                targetEntity.m_5997_((double)(-Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback), 0.1, (double)(Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback));
            }
            attackerLiving.m_20256_(attackerLiving.m_20184_().m_82542_(0.6, 1.0, 0.6));
            attackerLiving.m_6858_(false);
        }
        if (targetEntity.f_19864_ && targetEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)targetEntity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
            targetEntity.f_19864_ = false;
        }
        if ((attackerPlayer = context.getPlayerAttacker()) != null) {
            if (criticalModifier > 1.0f) {
                attackerPlayer.m_5704_(targetEntity);
            }
            if (isMagic) {
                attackerPlayer.m_5700_(targetEntity);
            }
            level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), context.getSound(), attackerLiving.m_5720_(), 1.0f, 1.0f);
        }
        if (damageDealt > 2.0f && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int particleCount = (int)(damageDealt * 0.5f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), particleCount, 0.1, 0.0, 0.1, 0.2);
        }
        attackerLiving.m_21335_(targetEntity);
        if (targetLiving != null) {
            EnchantmentHelper.m_44823_((LivingEntity)targetLiving, (Entity)attackerLiving);
        }
        for (ModifierEntry entry : modifiers) {
            entry.getHook(ModifierHooks.MELEE_HIT).afterMeleeHit(tool, entry, context, damageDealt);
        }
        float speed = tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue();
        int time = Math.round(20.0f / speed);
        if (time < targetEntity.f_19802_) {
            targetEntity.f_19802_ = (targetEntity.f_19802_ + time) / 2;
        }
        if (attackerPlayer != null) {
            if (targetLiving != null) {
                ItemStack held;
                if (!(level.f_46443_ || isExtraAttack || (held = attackerLiving.m_6844_(sourceSlot)).m_41619_())) {
                    held.m_41640_(targetLiving, attackerPlayer);
                }
                attackerPlayer.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
            }
            if (projectile == null) {
                attackerPlayer.m_36399_(0.1f);
            }
            if (!isExtraAttack && projectile == null) {
                attackerPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            }
        }
        if (!tool.hasTag(TinkerTags.Items.UNARMED)) {
            int durabilityLost;
            int n = durabilityLost = targetLiving != null ? 1 : 0;
            if (!tool.hasTag(TinkerTags.Items.MELEE_PRIMARY)) {
                durabilityLost *= 2;
            }
            if (projectile != null) {
                ToolDamageUtil.damage(tool, durabilityLost, attackerLiving, attackerLiving.m_6844_(sourceSlot));
            } else {
                ToolDamageUtil.damageAnimated(tool, durabilityLost, attackerLiving, sourceSlot);
            }
        }
        return true;
    }

    public static void spawnAttackParticle(ParticleOptions particleData, Entity entity, double height) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double xd = -Mth.m_14031_((float)(entity.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(entity.m_146909_() / 180.0f * (float)Math.PI));
            double zd = Mth.m_14089_((float)(entity.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(entity.m_146909_() / 180.0f * (float)Math.PI));
            double yd = -Mth.m_14031_((float)(entity.m_146909_() / 180.0f * (float)Math.PI));
            server.m_8767_(particleData, entity.m_20185_() + xd, entity.m_20186_() + (double)entity.m_20206_() * height, entity.m_20189_() + zd, 0, xd, yd, zd, 0.0);
        }
    }

    @Nullable
    public static AttributeInstance disableKnockback(@Nullable LivingEntity living) {
        AttributeInstance instance;
        if (living != null && (instance = living.m_21051_(Attributes.f_22278_)) != null && !instance.m_22109_(ANTI_KNOCKBACK_MODIFIER)) {
            instance.m_22118_(ANTI_KNOCKBACK_MODIFIER);
            return instance;
        }
        return null;
    }

    public static void enableKnockback(@Nullable AttributeInstance instance) {
        if (instance != null) {
            instance.m_22130_(ANTI_KNOCKBACK_MODIFIER);
        }
    }

    public static boolean hurtNoInvulnerableTime(Entity target, @Nullable LivingEntity living, DamageSource source, float damage) {
        float oldLastDamage = living == null ? 0.0f : living.f_20898_;
        int lastInvulnerableTime = target.f_19802_;
        target.f_19802_ = 0;
        boolean hit = target.m_6469_(source, damage);
        target.f_19802_ = lastInvulnerableTime;
        if (living != null) {
            living.f_20898_ += oldLastDamage;
        }
        return hit;
    }

    public static boolean hurtNoInvulnerableTime(Entity target, DamageSource source, float damage) {
        return ToolAttackUtil.hurtNoInvulnerableTime(target, ToolAttackUtil.getLivingEntity(target), source, damage);
    }

    public static boolean attackEntitySecondary(DamageSource source, float damage, Entity target, @Nullable LivingEntity living, boolean noKnockback) {
        AttributeInstance knockbackResistance = null;
        if (noKnockback) {
            knockbackResistance = ToolAttackUtil.disableKnockback(living);
        }
        boolean hit = ToolAttackUtil.hurtNoInvulnerableTime(target, living, source, damage);
        if (noKnockback) {
            ToolAttackUtil.enableKnockback(knockbackResistance);
        }
        return hit;
    }

    @Deprecated(forRemoval=true)
    public static DoubleSupplier getCooldownFunction(Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return () -> OffhandCooldownTracker.getCooldown((Player)player);
        }
        return () -> player.m_36403_(0.5f);
    }

    @Deprecated(forRemoval=true)
    public static float getSlotAttribute(IToolStackView tool, LivingEntity holder, EquipmentSlot slotType, Attribute attribute, float toolValue) {
        if (slotType == EquipmentSlot.MAINHAND) {
            return (float)holder.m_21133_(attribute);
        }
        return ToolAttackUtil.getToolAttribute(tool, holder, attribute, toolValue);
    }

    @Deprecated(forRemoval=true)
    public static float getAttributeAttackDamage(IToolStackView tool, LivingEntity holder, EquipmentSlot slotType) {
        if (holder.m_9236_().f_46443_) {
            return (float)holder.m_21133_(Attributes.f_22281_);
        }
        return ToolAttackUtil.getSlotAttribute(tool, holder, slotType, Attributes.f_22281_, tool.getStats().get(ToolStats.ATTACK_DAMAGE).floatValue());
    }

    @Deprecated(forRemoval=true)
    public static boolean dealDefaultDamage(LivingEntity attacker, Entity target, float damage) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            return target.m_6469_(attacker.m_269291_().m_269075_(player), damage);
        }
        return target.m_6469_(attacker.m_269291_().m_269333_(attacker), damage);
    }

    @Deprecated(forRemoval=true)
    public static boolean attackEntity(IToolStackView tool, LivingEntity attackerLiving, InteractionHand hand, Entity targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack) {
        return ToolAttackUtil.attackEntity(tool, attackerLiving, hand, targetEntity, cooldownFunction, isExtraAttack, Util.getSlotType(hand));
    }

    @Deprecated(forRemoval=true)
    public static boolean attackEntity(IToolStackView tool, LivingEntity attackerLiving, InteractionHand hand, Entity targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack, EquipmentSlot sourceSlot) {
        boolean success;
        if (!ToolAttackUtil.canPerformAttack(tool)) {
            return false;
        }
        if (!ToolAttackUtil.isAttackable(attackerLiving, targetEntity)) {
            return true;
        }
        ToolAttackContext.Builder builder = ToolAttackContext.attacker(attackerLiving).target(targetEntity).slot(sourceSlot, hand).cooldown((float)cooldownFunction.getAsDouble());
        if (sourceSlot == EquipmentSlot.MAINHAND) {
            builder.applyAttributes();
        } else {
            builder.toolAttributes(tool);
        }
        if (isExtraAttack) {
            builder.extraAttack();
        }
        return (success = ToolAttackUtil.performAttack(tool, builder.build())) || !isExtraAttack;
    }

    @Deprecated(forRemoval=true)
    public static boolean extraEntityAttack(IToolStackView tool, LivingEntity attackerLiving, InteractionHand hand, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(tool, attackerLiving, hand, targetEntity, NO_COOLDOWN, true);
    }
}

