/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module.aoe;

import com.google.common.collect.AbstractIterator;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record VeiningAOEIterator(int maxDistance) implements AreaOfEffectIterator.Loadable
{
    public static final RecordLoadable<VeiningAOEIterator> LOADER = RecordLoadable.create((RecordField)IntLoadable.FROM_ZERO.defaultField("max_distance", (Object)0, true, VeiningAOEIterator::maxDistance), VeiningAOEIterator::new);

    public RecordLoadable<VeiningAOEIterator> getLoader() {
        return LOADER;
    }

    @Override
    public Iterable<BlockPos> getBlocks(IToolStackView tool, UseOnContext context, BlockState state, AreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getVolatileData().getInt(IModifiable.EXPANDED);
        return VeiningAOEIterator.calculate(state, context.m_43725_(), context.m_8083_(), this.maxDistance + expanded);
    }

    public static Iterable<BlockPos> calculate(BlockState state, Level world, BlockPos origin, int maxDistance) {
        return () -> new VeiningIterator(world, origin, state.m_60734_(), maxDistance);
    }

    private static class VeiningIterator
    extends AbstractIterator<BlockPos> {
        private final Set<BlockPos> visited = new HashSet<BlockPos>();
        private final Queue<DistancePos> queue = new ArrayDeque<DistancePos>();
        private final Level world;
        private final Block target;
        private final int maxDistance;

        private VeiningIterator(Level world, BlockPos origin, Block target, int maxDistance) {
            this.world = world;
            this.target = target;
            this.maxDistance = maxDistance;
            this.visited.add(origin);
            if (maxDistance > 0) {
                this.enqueueNeighbors(origin, 1);
            }
        }

        private void enqueueNeighbors(BlockPos pos, int distance) {
            for (Direction direction : Direction.values()) {
                BlockPos offset = pos.m_121945_(direction);
                if (this.visited.contains(offset)) continue;
                this.visited.add(offset);
                this.queue.add(new DistancePos(offset, distance));
            }
        }

        protected BlockPos computeNext() {
            while (!this.queue.isEmpty()) {
                DistancePos distancePos = this.queue.remove();
                BlockPos pos = distancePos.pos;
                if (!this.world.m_8055_(pos).m_60713_(this.target)) continue;
                int distance = distancePos.distance;
                if (distance < this.maxDistance) {
                    this.enqueueNeighbors(pos, distance + 1);
                }
                return pos;
            }
            return (BlockPos)this.endOfData();
        }
    }

    private record DistancePos(BlockPos pos, int distance) {
    }
}

