/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.adding.DisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class MultilevelModifierRecipe
extends ModifierRecipe
implements IMultiRecipe<IDisplayModifierRecipe> {
    public static final RecordLoadable<MultilevelModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)SizedIngredient.LOADABLE.list(0).defaultField("inputs", List.of(), r -> r.inputs), (RecordField)TOOLS_FIELD, (RecordField)MAX_TOOL_SIZE_FIELD, (RecordField)RESULT_FIELD, (RecordField)ALLOW_CRYSTAL_FIELD, (RecordField)LevelEntry.LOADABLE.list(1).requiredField("levels", r -> r.levels), (RecordField)CHECK_TRAIT_LEVEL_FIELD, MultilevelModifierRecipe::new).validate((recipe, error) -> {
        if (recipe.inputs.isEmpty() && !recipe.allowCrystal) {
            throw error.create("Must either have inputs or allow crystal");
        }
        return recipe;
    });
    private final List<LevelEntry> levels;
    private List<IDisplayModifierRecipe> displayRecipes = null;

    protected MultilevelModifierRecipe(ResourceLocation id, List<SizedIngredient> inputs, Ingredient toolRequirement, int maxToolSize, ModifierId result, boolean allowCrystal, List<LevelEntry> levels, boolean checkTraitLevel) {
        super(id, inputs, toolRequirement, maxToolSize, result, levels.get((int)0).level, levels.get((int)0).slots, allowCrystal, checkTraitLevel);
        this.levels = levels;
    }

    public static RecipeResult<LazyToolStack> missingLevelError(List<LevelEntry> levels, int newLevel, LazyModifier result, boolean checkTraitLevel) {
        int min = levels.get((int)0).level.min();
        if (newLevel < min) {
            return RecipeResult.failure(checkTraitLevel ? KEY_MIN_LEVEL_TRAITS : KEY_MIN_LEVEL, result.get().getDisplayName(min - 1));
        }
        return RecipeResult.failure(checkTraitLevel ? KEY_MAX_LEVEL_TRAITS : KEY_MAX_LEVEL, result.get().getDisplayName(), levels.get((int)(levels.size() - 1)).level.max());
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool = inv.getTinkerable();
        int newLevel = this.getNewLevel(tool);
        LevelEntry levelEntry = LevelEntry.find(this.levels, newLevel);
        if (levelEntry == null) {
            return MultilevelModifierRecipe.missingLevelError(this.levels, newLevel, this.result, this.checkTraitLevel);
        }
        SlotType.SlotCount slots = levelEntry.slots();
        Component requirements = MultilevelModifierRecipe.checkSlots(tool, slots);
        if (requirements != null) {
            return RecipeResult.failure(requirements);
        }
        tool = tool.copy();
        if (slots != null) {
            tool.getPersistentData().addSlots(slots.type(), -slots.count());
        }
        tool.addModifier(this.result.getId(), 1);
        Component toolValidation = tool.tryValidate();
        if (toolValidation != null) {
            return RecipeResult.failure(toolValidation);
        }
        return this.success(tool, inv);
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.multilevelModifierSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes(RegistryAccess access) {
        if (this.inputs.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.displayRecipes == null) {
            DisplayModifierRecipe.Builder builder = DisplayModifierRecipe.builder().id(this.m_6423_()).ingredients(this.inputs).resultSlots(this.getResultSlots()).toolWithoutModifier(this.getToolWithoutModifier()).toolWithModifier(this.getToolWithModifier());
            this.displayRecipes = Streams.concat((Stream[])new Stream[]{Stream.of(this), this.levels.stream().skip(1L).map(levelEntry -> builder.copy().result(new ModifierEntry(this.result, levelEntry.level.min())).level(levelEntry.level).slots(levelEntry.slots).build())}).toList();
        }
        return this.displayRecipes;
    }

    public record LevelEntry(@Nullable SlotType.SlotCount slots, IntRange level) {
        public static final RecordLoadable<LevelEntry> LOADABLE = RecordLoadable.create((RecordField)SlotType.SlotCount.LOADABLE.nullableField("slots", LevelEntry::slots), (RecordField)ModifierEntry.VALID_LEVEL.requiredField("level", LevelEntry::level), LevelEntry::new);

        public boolean matches(int level) {
            return this.level.test(level);
        }

        @Nullable
        public static LevelEntry find(List<LevelEntry> levels, int newLevel) {
            for (LevelEntry check : levels) {
                if (!check.matches(newLevel)) continue;
                return check;
            }
            return null;
        }
    }
}

