/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.recipe.modifiers.adding.MultilevelModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;

public abstract class AbstractMultilevelModifierRecipeBuilder<T extends AbstractMultilevelModifierRecipeBuilder<T>>
extends AbstractRecipeBuilder<T> {
    protected final ModifierId result;
    protected final List<MultilevelModifierRecipe.LevelEntry> levels = new ArrayList<MultilevelModifierRecipe.LevelEntry>();
    protected boolean allowCrystal = true;
    protected Ingredient tools = Ingredient.f_43901_;
    protected int maxToolSize = 16;
    protected boolean checkTraitLevel = false;

    private T self() {
        return (T)((Object)this);
    }

    public T setTools(Ingredient tools, int maxSize) {
        this.tools = tools;
        this.maxToolSize = maxSize;
        return this.self();
    }

    public T setTools(Ingredient tools) {
        return this.setTools(tools, 16);
    }

    public T setTools(TagKey<Item> tag) {
        return this.setTools(Ingredient.m_204132_(tag));
    }

    public T allowCrystal() {
        this.allowCrystal = true;
        return this.self();
    }

    public T disallowCrystal() {
        this.allowCrystal = false;
        return this.self();
    }

    public T checkTraitLevel() {
        this.checkTraitLevel = true;
        return this.self();
    }

    private T addLevelRange(@Nullable SlotType.SlotCount slots, int minLevel, int maxLevel) {
        if (minLevel > maxLevel) {
            throw new JsonSyntaxException("minLevel must be less than or equal to maxLevel");
        }
        if (!this.levels.isEmpty() && minLevel <= this.levels.get(this.levels.size() - 1).level().max()) {
            throw new JsonSyntaxException("Level range must be greater than previous range");
        }
        this.levels.add(new MultilevelModifierRecipe.LevelEntry(slots, ModifierEntry.VALID_LEVEL.range(minLevel, maxLevel)));
        return this.self();
    }

    public T addLevelRange(SlotType slot, int slotCount, int minLevel, int maxLevel) {
        return this.addLevelRange(new SlotType.SlotCount(slot, slotCount), minLevel, maxLevel);
    }

    public T addLevel(SlotType slot, int slotCount, int level) {
        return this.addLevelRange(slot, slotCount, level, level);
    }

    public T addMinLevel(SlotType slot, int slotCount, int level) {
        return this.addLevelRange(slot, slotCount, level, Short.MAX_VALUE);
    }

    public T addLevelRange(int minLevel, int maxLevel) {
        return this.addLevelRange(null, minLevel, maxLevel);
    }

    public T addLevel(int level) {
        return this.addLevelRange(level, level);
    }

    public T addMinLevel(int level) {
        return this.addLevelRange(level, Short.MAX_VALUE);
    }

    public T saveSalvage(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.levels.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 level");
        }
        for (MultilevelModifierRecipe.LevelEntry levelEntry : this.levels) {
            if (levelEntry.slots() == null) continue;
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ModifierSalvage(id.m_266382_("_level_" + levelEntry.level().min()), this.tools, this.maxToolSize, this.result, levelEntry.level(), levelEntry.slots()), ModifierSalvage.LOADER, null));
        }
        return this.self();
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.result);
    }

    protected AbstractMultilevelModifierRecipeBuilder(ModifierId result) {
        this.result = result;
    }
}

