/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.capacity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.capacity.CapacitySourceModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record MeleeCapacityModule(IJsonPredicate<LivingEntity> target, IJsonPredicate<LivingEntity> attacker, LevelingInt grant, boolean before, @Nullable ModifierId owner, ModifierCondition<IToolStackView> condition) implements ModifierModule,
MeleeHitModifierHook,
CapacitySourceModule,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT);
    public static final RecordLoadable<MeleeCapacityModule> LOADER = RecordLoadable.create((RecordField)LivingEntityPredicate.LOADER.defaultField("target", MeleeCapacityModule::target), (RecordField)LivingEntityPredicate.LOADER.defaultField("attacker", MeleeCapacityModule::attacker), (RecordField)LevelingInt.LOADABLE.defaultField("grant", (Object)LevelingInt.ZERO, false, MeleeCapacityModule::grant), (RecordField)BooleanLoadable.INSTANCE.defaultField("run_before", (Object)false, true, MeleeCapacityModule::before), (RecordField)OWNER_FIELD, ModifierCondition.TOOL_FIELD, MeleeCapacityModule::new);

    public RecordLoadable<MeleeCapacityModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    private void apply(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context) {
        if (this.condition.matches(tool, modifier) && this.attacker.matches((Object)context.getAttacker()) && TinkerPredicate.matches(this.target, context.getLivingTarget())) {
            CapacitySourceModule.apply(tool, this.barModifier(tool, modifier), 1, this.grant.compute(modifier.getEffectiveLevel()));
        }
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        if (this.before) {
            this.apply(tool, modifier, context);
        }
        return knockback;
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (!this.before) {
            this.apply(tool, modifier, context);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CapacitySourceModule.Builder<Builder>
    implements LevelingInt.Builder<MeleeCapacityModule> {
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> attacker = LivingEntityPredicate.ANY;
        private boolean before = false;

        public Builder before() {
            return this.before(true);
        }

        @Override
        public MeleeCapacityModule amount(int flat, int eachLevel) {
            return new MeleeCapacityModule(this.target, this.attacker, new LevelingInt(flat, eachLevel), this.before, this.owner, this.condition);
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder attacker(IJsonPredicate<LivingEntity> attacker) {
            this.attacker = attacker;
            return this;
        }

        public Builder before(boolean before) {
            this.before = before;
            return this;
        }

        private Builder() {
        }
    }
}

