/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.predicate.modifier.ModifierPredicate;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatFormula;
import slimeknights.tconstruct.library.json.variable.stat.ConditionalStatVariable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public record ReduceToolDamageModule(IJsonPredicate<LivingEntity> holder, IJsonPredicate<ModifierId> cause, ConditionalStatFormula formula, boolean reinforcedTooltip, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ToolDamageModifierHook,
TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.TOOL_DAMAGE, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<ReduceToolDamageModule> LOADER = RecordLoadable.create((RecordField)LivingEntityPredicate.LOADER.defaultField("entity", ReduceToolDamageModule::holder), (RecordField)ModifierPredicate.LOADER.defaultField("cause", ReduceToolDamageModule::cause), (RecordField)ConditionalStatFormula.IDENTITY_LOADER.directField(ReduceToolDamageModule::formula), (RecordField)BooleanLoadable.INSTANCE.defaultField("reinforced_tooltip", (Object)false, false, ReduceToolDamageModule::reinforcedTooltip), ModifierCondition.TOOL_FIELD, ReduceToolDamageModule::new);

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public static int reduceDamage(int amount, float percentage) {
        if (percentage >= 1.0f) {
            return 0;
        }
        if (percentage <= 0.0f) {
            return amount;
        }
        int dealt = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(TConstruct.RANDOM.nextFloat() >= percentage)) continue;
            ++dealt;
        }
        return dealt;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        if (this.condition.matches(tool, modifier)) {
            return ReduceToolDamageModule.reduceDamage(amount, this.formula.apply(tool, modifier, holder, 0.0f, 1.0f));
        }
        return amount;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder, @Nullable ItemStack stack, ModifierId cause) {
        if (this.condition.matches(tool, modifier) && this.cause.matches((Object)cause)) {
            return ReduceToolDamageModule.reduceDamage(amount, this.formula.apply(tool, modifier, holder, 0.0f, 1.0f));
        }
        return amount;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float percent;
        if (this.condition.matches(tool, entry) && (percent = this.formula.apply(tool, entry, (LivingEntity)(tooltipKey == TooltipKey.SHIFT ? player : null), 0.0f, 1.0f)) > 0.0f) {
            Modifier modifier = entry.getModifier();
            Component name = this.reinforcedTooltip ? Component.m_237115_((String)(modifier.getTranslationKey() + ".reinforced")) : modifier.getDisplayName();
            tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)(Util.PERCENT_FORMAT.format(percent) + " ")).m_7220_(name)));
        }
    }

    public RecordLoadable<ReduceToolDamageModule> getLoader() {
        return LOADER;
    }

    public static class Builder
    extends VariableFormula.Builder<Builder, ReduceToolDamageModule, ConditionalStatVariable> {
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private IJsonPredicate<ModifierId> cause = ModifierPredicate.ANY;
        private boolean reinforcedTooltip = false;

        private Builder() {
            super(ConditionalStatFormula.VARIABLES);
        }

        @Override
        @Deprecated(forRemoval=true)
        public Builder percent() {
            return this;
        }

        public Builder reinforcedTooltip() {
            this.reinforcedTooltip = true;
            return this;
        }

        @Override
        protected ReduceToolDamageModule build(ModifierFormula formula) {
            return new ReduceToolDamageModule(this.holder, this.cause, new ConditionalStatFormula(formula, this.variables, this.percent), this.reinforcedTooltip, this.condition);
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }

        public Builder cause(IJsonPredicate<ModifierId> cause) {
            this.cause = cause;
            return this;
        }

        public Builder reinforcedTooltip(boolean reinforcedTooltip) {
            this.reinforcedTooltip = reinforcedTooltip;
            return this;
        }
    }
}

