/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.materials;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;

enum MaterialTextureField implements RecordField<ResourceLocation, MaterialRenderInfo>
{
    INSTANCE;


    @Nullable
    public ResourceLocation get(JsonObject json, TypedMap context) {
        if (json.has("texture")) {
            return JsonHelper.getResourceLocation((JsonObject)json, (String)"texture", null);
        }
        MaterialVariantId material = Objects.requireNonNull((MaterialVariantId)context.get(MaterialVariantId.CONTEXT_KEY), "Unable to fetch material variant from context, this usually implements a broken JSON deserializer");
        if (GsonHelper.m_13855_((JsonObject)json, (String)"skipUniqueTexture", (boolean)false)) {
            TConstruct.LOG.warn("Using deprecated boolean skipUniqueTexture on material " + material + ", just set 'texture' to 'null'");
            return null;
        }
        return material.getLocation('_');
    }

    public void serialize(MaterialRenderInfo parent, JsonObject json) {
        ResourceLocation texture = parent.texture();
        if (texture == null) {
            json.add("texture", (JsonElement)JsonNull.INSTANCE);
        } else if (!texture.equals((Object)parent.id().getLocation('_'))) {
            json.addProperty("texture", texture.toString());
        }
    }

    @Nullable
    public ResourceLocation decode(FriendlyByteBuf buffer, TypedMap context) {
        return switch ((TextureType)buffer.m_130066_(TextureType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case TextureType.NONE -> null;
            case TextureType.DEFAULT -> Objects.requireNonNull((MaterialVariantId)context.get(MaterialVariantId.CONTEXT_KEY)).getLocation('_');
            case TextureType.NAME -> buffer.m_130281_();
        };
    }

    public void encode(FriendlyByteBuf buffer, MaterialRenderInfo parent) {
        ResourceLocation texture = parent.texture();
        if (texture == null) {
            buffer.m_130068_((Enum)TextureType.NONE);
        } else if (texture.equals((Object)parent.id().getLocation('_'))) {
            buffer.m_130068_((Enum)TextureType.DEFAULT);
        } else {
            buffer.m_130068_((Enum)TextureType.NAME);
            buffer.m_130085_(texture);
        }
    }

    private static enum TextureType {
        DEFAULT,
        NONE,
        NAME;

    }
}

