/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import slimeknights.mantle.item.TooltipItem;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.DirtType;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.block.SlimeVineBlock;

public class SlimeGrassSeedItem
extends TooltipItem {
    private final FoliageType foliage;

    public SlimeGrassSeedItem(Item.Properties properties, FoliageType foliage) {
        super(properties);
        this.foliage = foliage;
    }

    @Nullable
    private static DirtType getDirtType(Block block) {
        for (DirtType type : DirtType.values()) {
            if (TinkerWorld.allDirt.get((Enum)type) != block) continue;
            return type;
        }
        return null;
    }

    @Nullable
    private Block getVines() {
        return switch (this.foliage) {
            case FoliageType.SKY -> (SlimeVineBlock)TinkerWorld.skySlimeVine.get();
            case FoliageType.ENDER -> (SlimeVineBlock)TinkerWorld.enderSlimeVine.get();
            default -> null;
        };
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Block slimyVines;
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockState state = world.m_8055_(pos);
        BlockState newState = null;
        if (state.m_60734_() == Blocks.f_50191_ && (slimyVines = this.getVines()) != null) {
            newState = (BlockState)slimyVines.m_49966_().m_61124_(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.START));
            for (BooleanProperty prop : VineBlock.f_57838_.values()) {
                if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
                newState = (BlockState)newState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
            }
        }
        if (newState == null) {
            DirtType type = SlimeGrassSeedItem.getDirtType(state.m_60734_());
            if (type != null) {
                newState = ((Block)TinkerWorld.slimeGrass.get((Object)type).get((Enum)this.foliage)).m_49966_();
            } else {
                return InteractionResult.PASS;
            }
        }
        if (!world.f_46443_) {
            world.m_46597_(pos, newState);
            world.m_5594_(null, pos, newState.getSoundType((LevelReader)world, pos, (Entity)context.m_43723_()).m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            Player player = context.m_43723_();
            if (player == null || !player.m_7500_()) {
                context.m_43722_().m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

