/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockBreakModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.ShearsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.shared.TinkerEffects;
import slimeknights.tconstruct.tools.modifiers.effect.MagneticEffect;

public class MagneticModifier
extends Modifier
implements PlantHarvestModifierHook,
ShearsModifierHook,
BlockBreakModifierHook,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook.RedirectAfter,
ProjectileLaunchModifierHook,
SlingLaunchModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<Integer> MAGNET = TConstruct.createKey("magnet");

    public MagneticModifier() {
        MinecraftForge.EVENT_BUS.addListener(MagneticModifier::onLivingTick);
    }

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, ModifierHooks.PLANT_HARVEST, ModifierHooks.SHEAR_ENTITY, ModifierHooks.BLOCK_BREAK, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_SHOT, ModifierHooks.SLING_LAUNCH);
        hookBuilder.addModule(new ArmorLevelModule(MAGNET, false, null));
    }

    @Override
    public void afterBlockBreak(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context) {
        if (!context.isAOE() && !context.isProjectile() && tool.hasTag(TinkerTags.Items.HARVEST)) {
            ((MagneticEffect)((Object)TinkerEffects.magnetic.get())).apply(context.getLiving(), 30, modifier.getLevel() - 1);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && !context.isProjectile()) {
            ((MagneticEffect)((Object)TinkerEffects.magnetic.get())).apply(context.getAttacker(), 30, modifier.getLevel() - 1);
        }
    }

    @Override
    public void afterHarvest(IToolStackView tool, ModifierEntry modifier, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        Player player = context.m_43723_();
        if (player != null) {
            ((MagneticEffect)((Object)TinkerEffects.magnetic.get())).apply((LivingEntity)player, 30, modifier.getLevel() - 1);
        }
    }

    @Override
    public void afterShearEntity(IToolStackView tool, ModifierEntry modifier, Player player, Entity entity, boolean isTarget) {
        if (isTarget) {
            ((MagneticEffect)((Object)TinkerEffects.magnetic.get())).apply((LivingEntity)player, 30, modifier.getLevel() - 1);
        }
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (primary) {
            ((MagneticEffect)((Object)TinkerEffects.magnetic.get())).apply(shooter, 30, modifier.getLevel() - 1);
        }
    }

    @Override
    public void afterSlingLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity holder, LivingEntity target, ModifierEntry slingSource, float force, float multiplier, Vec3 angle) {
        ((MagneticEffect)((Object)TinkerEffects.magnetic.get())).apply(holder, 30, modifier.getLevel() - 1);
    }

    private static void onLivingTick(LivingEvent.LivingTickEvent event) {
        int level;
        LivingEntity entity = event.getEntity();
        if (!entity.m_5833_() && (entity.f_19797_ & 1) == 0 && (level = ArmorLevelModule.getLevel(entity, MAGNET)) > 0) {
            MagneticModifier.applyMagnet(entity, level - 1);
        }
    }

    public static <T extends Entity> void applyVelocity(LivingEntity entity, int amplifier, Class<T> targetClass, int minRange, float speed, int maxPush) {
        MagneticModifier.applyVelocity(entity.m_9236_(), entity.m_20182_(), amplifier, targetClass, minRange, speed, maxPush);
    }

    public static <T extends Entity> void applyVelocity(Level level, Vec3 origin, int amplifier, Class<T> targetClass, int minRange, float speed, int maxPush) {
        double x = origin.f_82479_;
        double y = origin.f_82480_;
        double z = origin.f_82481_;
        float range = minRange + amplifier;
        List targets = level.m_45976_(targetClass, new AABB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
        int pulled = 0;
        for (Entity target : targets) {
            if (target.m_213877_() || target.m_20182_().m_82557_(origin) < 0.25) continue;
            Vec3 vec = origin.m_82492_(target.m_20185_(), target.m_20186_(), target.m_20189_()).m_82541_().m_82490_((double)(speed * (float)(amplifier + 1)));
            if (!target.m_20068_()) {
                vec = vec.m_82520_(0.0, (double)0.04f, 0.0);
            }
            target.m_20256_(target.m_20184_().m_82549_(vec));
            if (++pulled <= maxPush) continue;
            break;
        }
    }

    public static void applyMagnet(LivingEntity entity, int amplifier) {
        MagneticModifier.applyVelocity(entity, amplifier, ItemEntity.class, 3, 0.05f, 100);
    }
}

