/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;

public class ToolDamageUtil {
    public static void breakTool(ItemStack stack) {
        stack.m_41784_().m_128379_("tic_broken", true);
    }

    public static boolean isBroken(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128471_("tic_broken");
    }

    public static int getFakeMaxDamage(ItemStack stack) {
        if (!stack.m_41720_().m_41465_()) {
            return 0;
        }
        ToolStack tool = ToolStack.from(stack);
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        return tool.isBroken() ? durability + 1 : durability;
    }

    public static boolean directDamage(IToolStackView tool, int amount, @Nullable LivingEntity entity, @Nullable ItemStack stack) {
        int damage;
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_7500_()) {
            return false;
        }
        int durability = tool.getStats().getInt(ToolStats.DURABILITY);
        int current = durability - (damage = tool.getDamage());
        if ((amount = Math.min(amount, current)) > 0) {
            int newDamage = damage + amount;
            if (entity instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)entity;
                if (stack == null) {
                    stack = entity.m_21205_();
                }
                CriteriaTriggers.f_10586_.m_43669_(player2, stack, newDamage);
            }
            tool.setDamage(newDamage);
            return newDamage >= durability;
        }
        return false;
    }

    public static boolean damage(IToolStackView tool, int amount, @Nullable LivingEntity entity, @Nullable ItemStack stack, ModifierId cause) {
        if (amount <= 0 || tool.isBroken() || tool.isUnbreakable() || !tool.hasTag(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            amount = entry.getHook(ModifierHooks.TOOL_DAMAGE).onDamageTool(tool, entry, amount, entity, stack, cause);
            if (amount > 0) continue;
            return false;
        }
        return ToolDamageUtil.directDamage(tool, amount, entity, stack);
    }

    public static boolean damage(IToolStackView tool, int amount, @Nullable LivingEntity entity, @Nullable ItemStack stack) {
        return ToolDamageUtil.damage(tool, amount, entity, stack, ModifierId.EMPTY);
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, LivingEntity entity, EquipmentSlot slot, ModifierId cause) {
        if (ToolDamageUtil.damage(tool, amount, entity, entity.m_6844_(slot), cause)) {
            entity.m_21166_(slot);
            return true;
        }
        return false;
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, LivingEntity entity, EquipmentSlot slot) {
        return ToolDamageUtil.damageAnimated(tool, amount, entity, slot, ModifierId.EMPTY);
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, LivingEntity entity, InteractionHand hand, ModifierId cause) {
        if (ToolDamageUtil.damage(tool, amount, entity, entity.m_21120_(hand), cause)) {
            entity.m_21190_(hand);
            return true;
        }
        return false;
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, LivingEntity entity, InteractionHand hand) {
        return ToolDamageUtil.damageAnimated(tool, amount, entity, hand, ModifierId.EMPTY);
    }

    public static boolean damageAnimated(IToolStackView tool, int amount, LivingEntity entity) {
        return ToolDamageUtil.damageAnimated(tool, amount, entity, entity.m_6117_() ? entity.m_7655_() : InteractionHand.MAIN_HAND);
    }

    public static boolean damageLauncher(IToolStackView tool, int amount, LivingEntity entity, Projectile projectile, ModifierId modifier) {
        if (projectile.m_6095_() != TinkerTools.fishingHook.get()) {
            return ToolDamageUtil.damageAnimated(tool, amount, entity, entity.m_7655_(), modifier);
        }
        return false;
    }

    public static <T extends LivingEntity> void handleDamageItem(ItemStack stack, int amount, T damager, Consumer<T> onBroken) {
        if (stack.m_41720_().m_41465_() && ToolDamageUtil.damage(ToolStack.from(stack), amount, damager, stack)) {
            onBroken.accept(damager);
        }
    }

    public static void repair(IToolStackView tool, int amount) {
        if (amount <= 0) {
            return;
        }
        int damage = tool.getDamage();
        if (damage == 0) {
            return;
        }
        int newDamage = damage - Math.min(amount, damage);
        tool.setDamage(newDamage);
    }
}

