/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.json.variable.entity.EntityVariable;

public record EntityLightVariable(@Nullable LightLayer lightLayer) implements EntityVariable
{
    public static final RecordLoadable<EntityLightVariable> LOADER = RecordLoadable.create((RecordField)TinkerLoadables.LIGHT_LAYER.nullableField("light_layer", EntityLightVariable::lightLayer), EntityLightVariable::new);

    private static int getSkyLight(Level level, BlockPos pos) {
        return level.m_45517_(LightLayer.SKY, pos) - level.m_7445_();
    }

    public static int getLightLevel(Level level, @Nullable LightLayer lightLayer, BlockPos pos) {
        if (lightLayer == null) {
            return Math.max(EntityLightVariable.getSkyLight(level, pos), level.m_45517_(LightLayer.BLOCK, pos));
        }
        if (lightLayer == LightLayer.SKY) {
            return Math.max(0, EntityLightVariable.getSkyLight(level, pos));
        }
        return level.m_45517_(lightLayer, pos);
    }

    @Override
    public float getValue(LivingEntity entity) {
        return EntityLightVariable.getLightLevel(entity.m_9236_(), this.lightLayer, entity.m_20183_());
    }

    public RecordLoadable<EntityLightVariable> getLoader() {
        return LOADER;
    }
}

