/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.predicate;

import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.EnumLoadable;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;

public interface VariableRangePredicate {
    public static final LoadableField<Float, VariableRangePredicate> MIN_FIELD = FloatLoadable.ANY.defaultField("min", (Object)Float.valueOf(Float.NEGATIVE_INFINITY), VariableRangePredicate::min);
    public static final LoadableField<Float, VariableRangePredicate> MAX_FIELD = FloatLoadable.ANY.defaultField("min", (Object)Float.valueOf(Float.POSITIVE_INFINITY), VariableRangePredicate::max);
    public static final LoadableField<IntervalType, VariableRangePredicate> INTERVAL_FIELD = IntervalType.LOADABLE.defaultField("interval", (Object)IntervalType.CLOSED, true, VariableRangePredicate::interval);

    public float min();

    public float max();

    public IntervalType interval();

    default public boolean matches(float value) {
        return this.interval().test(value, this.min(), this.max());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IntervalType {
        OPEN{

            @Override
            public boolean test(float value, float min, float max) {
                return min < value && value < max;
            }
        }
        ,
        CLOSED{

            @Override
            public boolean test(float value, float min, float max) {
                return min <= value && value <= max;
            }
        }
        ,
        LEFT_OPEN{

            @Override
            public boolean test(float value, float min, float max) {
                return min < value && value <= max;
            }
        }
        ,
        RIGHT_OPEN{

            @Override
            public boolean test(float value, float min, float max) {
                return min <= value && value < max;
            }
        };

        public static final EnumLoadable<IntervalType> LOADABLE;

        public abstract boolean test(float var1, float var2, float var3);

        static {
            LOADABLE = new EnumLoadable(IntervalType.class);
        }
    }
}

