package slimeknights.tconstruct.library.recipe.casting;

import lombok.AllArgsConstructor;
import lombok.Getter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;

import javax.annotation.Nullable;
import java.util.List;

/**
 * Simple implementation of a display casting recipe, generated by certain recipe types
 */
@Getter
@AllArgsConstructor
public final class DisplayCastingRecipe implements IDisplayableCastingRecipe {
  @Nullable
  private final ResourceLocation recipeId;
  private final RecipeType<?> type;
  private final List<ItemStack> castItems;
  private final List<FluidStack> fluids;
  private final List<ItemStack> outputs;
  private final int coolingTime;
  private final boolean consumed;

  public DisplayCastingRecipe(@Nullable ResourceLocation recipeId, RecipeType<?> type, List<ItemStack> castItems, List<FluidStack> fluids, ItemStack output, int coolingTime, boolean consumed) {
    this(recipeId, type, castItems, fluids, List.of(output), coolingTime, consumed);
  }

  /** @deprecated use {@link #DisplayCastingRecipe(ResourceLocation,RecipeType,List,List,ItemStack,int,boolean)} */
  @Deprecated
  public DisplayCastingRecipe(RecipeType<?> type, List<ItemStack> castItems, List<FluidStack> fluids, ItemStack output, int coolingTime, boolean consumed) {
    this(null, type, castItems, fluids, output, coolingTime, consumed);
  }

  @Override
  public ItemStack getOutput() {
    return outputs.get(0);
  }

  @Override
  public boolean hasCast() {
    return !castItems.isEmpty();
  }
}
