/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction.sling;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.UseAnim;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.interaction.UsingToolModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public interface SlingModule
extends ModifierModule,
GeneralInteractionModifierHook,
UsingToolModifierHook,
ModifierCondition.ConditionalModule<IToolStackView> {
    public static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING);
    public static final RecordField<Float, SlingModule> FORCE_FIELD = FloatLoadable.FROM_ZERO.requiredField("force_multiplier", SlingModule::forceMultiplier);
    public static final RecordField<Float, SlingModule> DRAWTIME_FIELD = FloatLoadable.FROM_ZERO.requiredField("drawtime_multiplier", SlingModule::drawtimeMultiplier);
    public static final RecordField<IJsonPredicate<LivingEntity>, SlingModule> TARGET_FIELD = LivingEntityPredicate.LOADER.defaultField("target", SlingModule::target);

    public float forceMultiplier();

    public float drawtimeMultiplier();

    public IJsonPredicate<LivingEntity> target();

    @Override
    default public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    default public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK && this.condition().matches(tool, modifier)) {
            GeneralInteractionModifierHook.startUsingWithDrawtime(tool, modifier.getId(), (LivingEntity)player, hand, this.drawtimeMultiplier());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    default public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 72000;
    }

    @Override
    default public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return ModifierUtil.blockWhileCharging(tool, UseAnim.BOW);
    }

    default public float getCharge(IToolStackView tool, ModifierEntry entry, int timeLeft) {
        return GeneralInteractionModifierHook.getToolCharge(tool, this.getUseDuration(tool, entry) - timeLeft);
    }

    public static float getPower(IToolStackView tool, LivingEntity living) {
        return ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.PROJECTILE_DAMAGE) / 2.0f * ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.VELOCITY);
    }
}

