/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.combat;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.Util;

public record LifestealModule(LevelingValue percent, LevelingInt durabilityUsage, IJsonPredicate<LivingEntity> attacker, IJsonPredicate<LivingEntity> target, IntRange modifierLevel) implements ModifierModule,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook,
ProjectileLaunchModifierHook,
ProjectileHitModifierHook,
TooltipModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_HIT, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<LifestealModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("percentage", LifestealModule::percent), (RecordField)LevelingInt.LOADABLE.requiredField("durability_usage", LifestealModule::durabilityUsage), (RecordField)LivingEntityPredicate.LOADER.defaultField("attacker", LifestealModule::attacker), (RecordField)LivingEntityPredicate.LOADER.defaultField("target", LifestealModule::target), ModifierEntry.VALID_LEVEL.defaultField("modifier_level", LifestealModule::modifierLevel), LifestealModule::new);

    @Override
    public RecordLoadable<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onMonsterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage) {
        LivingEntity attacker = context.getAttacker();
        Entity target = context.getTarget();
        if (damage > 0.0f && this.modifierLevel.test(modifier.getLevel()) && !context.getTarget().m_6095_().m_204039_(TinkerTags.EntityTypes.NECROTIC_BLACKLIST) && this.attacker.matches((Object)attacker) && TinkerPredicate.matches(this.target, target)) {
            float level = modifier.getEffectiveLevel();
            float percent = this.percent.compute(modifier.getEffectiveLevel());
            if (percent > 0.0f) {
                attacker.m_5634_(percent * damage);
                attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                int durability = this.durabilityUsage.compute(level);
                if (durability > 0) {
                    ToolDamageUtil.damageAnimated(tool, durability, attacker, context.getSlotType(), modifier.getId());
                }
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged() && context.isCritical()) {
            this.onMonsterMeleeHit(tool, modifier, context, damageDealt);
        }
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        int durabilityUsage;
        if (primary && this.attacker.matches((Object)shooter) && (durabilityUsage = this.durabilityUsage.compute(modifier.getEffectiveLevel())) > 0) {
            ToolDamageUtil.damageLauncher(tool, durabilityUsage, shooter, projectile, modifier.getId());
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target, boolean notBlocked) {
        if (target != null && attacker != null && !target.m_6095_().m_204039_(TinkerTags.EntityTypes.NECROTIC_BLACKLIST) && this.attacker.matches((Object)attacker) && this.target.matches((Object)target)) {
            float power;
            float level = modifier.getEffectiveLevel();
            float percent = this.percent.compute(modifier.getEffectiveLevel());
            if (percent > 0.0f && (power = ProjectileWithPower.getDamage(projectile)) > 0.0f) {
                attacker.m_5634_(percent * Math.min(target.m_21223_(), power));
                attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                int durabilityUsage = this.durabilityUsage.compute(level);
                if (durabilityUsage > 0) {
                    ModifierUtil.updateFishingRod(projectile, durabilityUsage, false, modifier.getId());
                }
            }
        }
        return false;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float percent;
        if (TinkerPredicate.matchesInTooltip(this.attacker, (LivingEntity)player, tooltipKey) && (percent = this.percent.compute(entry.getEffectiveLevel())) > 0.0f) {
            Modifier modifier = entry.getModifier();
            tooltip.add((Component)modifier.applyStyle(Component.m_237113_((String)(Util.PERCENT_FORMAT.format(percent) + " ")).m_7220_((Component)Component.m_237115_((String)(modifier.getTranslationKey() + ".lifesteal")))));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements LevelingValue.Builder<LifestealModule> {
        private LevelingInt durabilityUsage = LevelingInt.eachLevel(1);
        private IJsonPredicate<LivingEntity> attacker = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private IntRange modifierLevel = ModifierEntry.VALID_LEVEL;

        private Builder() {
        }

        @Override
        public LifestealModule amount(float flat, float eachLevel) {
            return new LifestealModule(new LevelingValue(flat, eachLevel), this.durabilityUsage, this.attacker, this.target, this.modifierLevel);
        }

        public Builder durabilityUsage(LevelingInt durabilityUsage) {
            this.durabilityUsage = durabilityUsage;
            return this;
        }

        public Builder attacker(IJsonPredicate<LivingEntity> attacker) {
            this.attacker = attacker;
            return this;
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder modifierLevel(IntRange modifierLevel) {
            this.modifierLevel = modifierLevel;
            return this;
        }
    }
}

