/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;

public class ToolDefinition
implements IdAwareObject {
    public static final ToolDefinition EMPTY = new ToolDefinition(TConstruct.getResource("empty"));
    private final ResourceLocation id;
    protected ToolDefinitionData data = ToolDefinitionData.EMPTY;

    public static ToolDefinition create(ResourceLocation id) {
        ToolDefinition definition = new ToolDefinition(id);
        ToolDefinitionLoader.getInstance().registerToolDefinition(definition);
        return definition;
    }

    public static ToolDefinition create(RegistryObject<? extends ItemLike> item) {
        return ToolDefinition.create(item.getId());
    }

    public static ToolDefinition create(IdAwareObject item) {
        return ToolDefinition.create(item.getId());
    }

    public <T> T getHook(ModuleHook<T> hook) {
        return this.data.getHook(hook);
    }

    public boolean hasMaterials() {
        return !this.data.getHook(ToolHooks.TOOL_MATERIALS).getStatTypes(this).isEmpty();
    }

    @VisibleForTesting
    public void setData(ToolDefinitionData data) {
        this.data = data;
    }

    protected void clearData() {
        this.setData(ToolDefinitionData.EMPTY);
    }

    public boolean isDataLoaded() {
        return this.data != ToolDefinitionData.EMPTY;
    }

    public ToolDefinition(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ToolDefinitionData getData() {
        return this.data;
    }
}

