/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import com.google.common.collect.AbstractIterator;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import net.minecraft.world.entity.EquipmentSlot;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class EquipmentIterator
extends AbstractIterator<EquipmentEntry> {
    protected final EquipmentEntry entry = new EquipmentEntry();
    private final ToolEntry[] tools;
    private final int[] lastModifier;
    private int lastTool = -1;
    private int lastPriority = Integer.MAX_VALUE;

    public static Iterable<EquipmentEntry> iterable(List<IToolStackView> tools, List<EquipmentSlot> slots) {
        if (tools.size() != slots.size()) {
            throw new IllegalArgumentException("Tools and slots sizes must match");
        }
        if (tools.isEmpty()) {
            return Collections.emptyList();
        }
        if (tools.size() == 1) {
            IToolStackView tool = tools.get(0);
            EquipmentSlot slot = slots.get(0);
            return () -> new SingleEquipmentIterator(tool, slot);
        }
        ToolEntry[] toolEntries = new ToolEntry[tools.size()];
        for (int i = 0; i < toolEntries.length; ++i) {
            toolEntries[i] = ToolEntry.from(tools.get(i), slots.get(i));
        }
        return () -> new EquipmentIterator(toolEntries);
    }

    private EquipmentIterator(ToolEntry[] tools) {
        this.tools = tools;
        this.lastModifier = new int[tools.length];
        this.findNextModifier();
        if (this.lastTool == -1) {
            this.endOfData();
        }
    }

    private void findNextModifier() {
        int max = Integer.MIN_VALUE;
        int index = -1;
        for (int toolIndex = 0; toolIndex < this.tools.length; ++toolIndex) {
            ModifierEntry entry;
            int priority;
            ToolEntry tool = this.tools[toolIndex];
            int modifierIndex = this.lastModifier[toolIndex];
            if (modifierIndex >= tool.size || (priority = (entry = tool.modifiers.get(modifierIndex)).getModifier().getPriority()) <= max) continue;
            max = priority;
            index = toolIndex;
        }
        if (index == -1) {
            this.entry.tool = null;
        } else {
            this.lastPriority = max;
            if (this.lastTool != index) {
                this.entry.tool = this.tools[index].tool;
                this.entry.slot = this.tools[index].slot;
            }
        }
        this.lastTool = index;
    }

    @CheckForNull
    protected EquipmentEntry computeNext() {
        ModifierEntry modifier;
        int modifierIndex = this.lastModifier[this.lastTool];
        ToolEntry tool = this.tools[this.lastTool];
        if (modifierIndex < tool.size && (modifier = tool.modifiers.get(modifierIndex)).getModifier().getPriority() == this.lastPriority) {
            this.entry.modifier = modifier;
            this.lastModifier[this.lastTool] = modifierIndex + 1;
            return this.entry;
        }
        this.findNextModifier();
        if (this.lastTool == -1) {
            return (EquipmentEntry)this.endOfData();
        }
        modifierIndex = this.lastModifier[this.lastTool];
        this.entry.modifier = this.tools[this.lastTool].modifiers.get(modifierIndex);
        this.lastModifier[this.lastTool] = modifierIndex + 1;
        return this.entry;
    }

    private record ToolEntry(IToolStackView tool, List<ModifierEntry> modifiers, int size, EquipmentSlot slot) {
        public static ToolEntry from(IToolStackView tool, EquipmentSlot slot) {
            List<ModifierEntry> modifiers = tool.getModifierList();
            return new ToolEntry(tool, modifiers, modifiers.size(), slot);
        }
    }

    public static class EquipmentEntry {
        private IToolStackView tool;
        private EquipmentSlot slot;
        private ModifierEntry modifier;

        public IToolStackView tool() {
            return this.tool;
        }

        public EquipmentSlot slot() {
            return this.slot;
        }

        public ModifierEntry modifier() {
            return this.modifier;
        }
    }

    private static class SingleEquipmentIterator
    extends AbstractIterator<EquipmentEntry> {
        private final EquipmentEntry entry = new EquipmentEntry();
        private final List<ModifierEntry> modifiers;
        private final int size;
        private int index = 0;

        private SingleEquipmentIterator(IToolStackView tool, EquipmentSlot slot) {
            this.entry.tool = tool;
            this.entry.slot = slot;
            this.modifiers = tool.getModifierList();
            this.size = this.modifiers.size();
        }

        @CheckForNull
        protected EquipmentEntry computeNext() {
            if (this.index >= this.size) {
                return (EquipmentEntry)this.endOfData();
            }
            this.entry.modifier = this.modifiers.get(this.index);
            ++this.index;
            return this.entry;
        }
    }
}

