/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable;

import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.floats.FloatStack;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.math.StackOperation;

public interface VariableFormula<T extends GenericLoaderRegistry.IHaveLoader> {
    public static final String[] EMPTY_STRINGS = new String[0];

    public ModifierFormula formula();

    public List<T> variables();

    public String[] variableNames();

    public boolean percent();

    public static float[] statModuleArguments(int variables, float level, float baseValue, float value, float multiplier) {
        float[] arguments = new float[4 + variables];
        arguments[0] = level;
        arguments[1] = value;
        arguments[2] = multiplier;
        arguments[3] = baseValue;
        return arguments;
    }

    public static String[] getNames(Map<String, ?> variables) {
        return variables.keySet().toArray(new String[0]);
    }

    public static abstract class Builder<T extends Builder<T, M, V>, M, V>
    extends ModifierFormula.Builder<T, M> {
        protected boolean percent = false;
        protected final Map<String, V> variables = new LinkedHashMap<String, V>();

        public Builder(String[] variables) {
            super(variables);
        }

        public T percent() {
            this.percent = true;
            return (T)this;
        }

        public T customVariable(String key, V variable) {
            if (LogicHelper.isInList((Object[])this.variableNames, (Object)key)) {
                throw new IllegalArgumentException("Variable " + key + " already exists in the module's variables");
            }
            V original = this.variables.put(key, variable);
            if (original != null) {
                throw new IllegalStateException("Duplicate variable name " + key + ", previous entry " + original);
            }
            return (T)this;
        }

        public FormulaVariableBuilder formula() {
            return new FormulaVariableBuilder();
        }

        public class FormulaVariableBuilder
        extends ModifierFormula.Builder.FormulaBuilder<FormulaVariableBuilder, M> {
            protected FormulaVariableBuilder() {
                super(Builder.this);
            }

            public FormulaVariableBuilder customVariable(String name) {
                if (!Builder.this.variables.containsKey(name)) {
                    throw new IllegalArgumentException("Unknown custom variable " + name);
                }
                return (FormulaVariableBuilder)this.operation(new SerializeVariableName(name));
            }

            public FormulaVariableBuilder customVariable(String name, V variable) {
                Builder.this.customVariable(name, variable);
                return (FormulaVariableBuilder)this.operation(new SerializeVariableName(name));
            }

            private record SerializeVariableName(String name) implements StackOperation
            {
                @Override
                public void perform(FloatStack stack, float[] variables) {
                    stack.push(0.0f);
                }

                @Override
                public JsonPrimitive serialize(String[] variableNames) {
                    return new JsonPrimitive("$" + this.name);
                }

                @Override
                public void toNetwork(FriendlyByteBuf buffer) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

