/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction.sling;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingAngleModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingForceModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;
import slimeknights.tconstruct.tools.TinkerToolActions;
import slimeknights.tconstruct.tools.modules.interaction.sling.SlingModule;

public record SlingLeapModule(float forceMultiplier, boolean leaveGround, float drawtimeMultiplier, float heightReduction, boolean biasUpwards, IJsonPredicate<LivingEntity> target, ModifierCondition<IToolStackView> condition) implements SlingModule
{
    public static final RecordLoadable<SlingLeapModule> LOADER = RecordLoadable.create((RecordField)FloatLoadable.ANY.requiredField("force_multiplier", SlingModule::forceMultiplier), (RecordField)BooleanLoadable.INSTANCE.requiredField("leave_ground", SlingLeapModule::leaveGround), (RecordField)DRAWTIME_FIELD, (RecordField)FloatLoadable.ANY.requiredField("height_reduction", SlingLeapModule::heightReduction), (RecordField)BooleanLoadable.INSTANCE.requiredField("bias_upwards", SlingLeapModule::biasUpwards), (RecordField)TARGET_FIELD, ModifierCondition.TOOL_FIELD, SlingLeapModule::new);

    public RecordLoadable<SlingLeapModule> getLoader() {
        return LOADER;
    }

    @Override
    public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        float charge;
        Level level = entity.m_9236_();
        if (this.condition.matches(tool, modifier) && this.target.matches((Object)entity) && (charge = this.getCharge(tool, modifier, timeLeft)) > 0.0f) {
            float multiplier = charge * Math.abs(this.forceMultiplier);
            float force = SlingForceModifierHook.modifySlingForce(tool, entity, entity, modifier, SlingModule.getPower(tool, entity) * multiplier, multiplier);
            if (force > 0.0f) {
                Vec3 look = entity.m_20154_();
                if (this.biasUpwards) {
                    look = look.m_82520_(0.0, Math.max(0.0, 0.5 - (double)force * 0.1 * (double)Mth.m_14205_((double)this.forceMultiplier)), 0.0);
                }
                look = look.m_82541_();
                RandomSource random = entity.m_217043_();
                float inaccuracy = ModifierUtil.getInaccuracy(tool, entity) * 0.0075f;
                Vec3 angle = new Vec3(look.f_82479_ + random.m_188583_() * (double)inaccuracy, (look.f_82480_ + random.m_188583_() * (double)inaccuracy) / (double)this.heightReduction, look.f_82481_ + random.m_188583_() * (double)inaccuracy);
                if (this.forceMultiplier < 0.0f) {
                    angle = angle.m_82542_(-1.0, -1.0, -1.0);
                }
                angle = SlingAngleModifierHook.modifySlingAngle(tool, entity, entity, modifier, force, multiplier, angle);
                entity.m_5997_((double)force * angle.f_82479_, (double)force * angle.f_82480_, (double)force * angle.f_82481_);
                if (this.leaveGround && entity.m_20096_()) {
                    entity.m_6478_(MoverType.SELF, new Vec3(0.0, (double)1.3f, 0.0));
                }
                SlimeBounceHandler.addBounceHandler(entity);
                SlingLaunchModifierHook.afterSlingLaunch(tool, entity, entity, modifier, force, multiplier, angle);
                if (!level.f_46443_) {
                    level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.SLIME_SLING.getSound(), entity.m_5720_(), 1.0f, 1.0f);
                    ToolDamageUtil.damageAnimated(tool, 1, entity);
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (!level.f_46443_) {
                        player.m_36399_(0.2f);
                        player.m_36335_().m_41524_(tool.getItem(), 3);
                    }
                    if (ModifierManager.isInTag(modifier.getId(), TinkerTags.Modifiers.DRILL_ATTACKS) && ModifierUtil.canPerformAction(tool, TinkerToolActions.DRILL_ATTACK)) {
                        player.m_204079_(20);
                    }
                }
                return;
            }
        }
        if (ModifierUtil.isActiveModifier(tool, modifier, activeModifier)) {
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.SLIME_SLING.getSound(), entity.m_5720_(), 1.0f, 0.5f);
        }
    }
}

