/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction;

import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolTankHelper;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ranged.ModifiableLauncherItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.entity.FluidEffectProjectile;

public record SpittingModule(LevelingInt shots) implements ModifierModule,
GeneralInteractionModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.GENERAL_INTERACT);
    public static final RecordLoadable<SpittingModule> LOADER = RecordLoadable.create((RecordField)LevelingInt.LOADABLE.requiredField("shots", SpittingModule::shots), SpittingModule::new);

    public RecordLoadable<SpittingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public int getUseDuration(IToolStackView tool, ModifierEntry modifier) {
        return 72000;
    }

    @Override
    public UseAnim getUseAction(IToolStackView tool, ModifierEntry modifier) {
        return ModifierUtil.blockWhileCharging(tool, UseAnim.BOW);
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        FluidStack fluid;
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK && (fluid = ToolTankHelper.TANK_HELPER.getFluid(tool)).getAmount() >= modifier.getLevel() && FluidEffectManager.INSTANCE.find(fluid.getFluid()).hasEffects()) {
            GeneralInteractionModifierHook.startUsingWithDrawtime(tool, modifier.getId(), (LivingEntity)player, hand, 1.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void onStoppedUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int timeLeft) {
        FluidEffects recipe;
        FluidStack fluid;
        int chargeTime;
        Level world = entity.m_9236_();
        if (!world.f_46443_ && (chargeTime = this.getUseDuration(tool, modifier) - timeLeft) > 0 && !(fluid = ToolTankHelper.TANK_HELPER.getFluid(tool)).isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEffects()) {
            float charge = GeneralInteractionModifierHook.getToolCharge(tool, chargeTime);
            float power = charge * ConditionalStatModifierHook.getModifiedStat(tool, entity, ToolStats.PROJECTILE_DAMAGE);
            int shots = this.shots.compute(modifier.getEffectiveLevel());
            int amount = Math.min(fluid.getAmount(), (int)((float)recipe.getAmount(fluid.getFluid()) * power) * shots) / shots;
            if (amount > 0) {
                float velocity = ConditionalStatModifierHook.getModifiedStat(tool, entity, ToolStats.VELOCITY) * charge * 3.0f;
                float inaccuracy = ModifierUtil.getInaccuracy(tool, entity);
                float startAngle = ModifiableLauncherItem.getAngleStart(shots);
                int primaryIndex = shots / 2;
                for (int shotIndex = 0; shotIndex < shots; ++shotIndex) {
                    FluidEffectProjectile spit = new FluidEffectProjectile(world, entity, new FluidStack(fluid, amount), power);
                    Vec3 upVector = entity.m_20289_(1.0f);
                    float angle = startAngle + (float)(10 * shotIndex);
                    Vector3f targetVector = entity.m_20252_(1.0f).m_252839_().rotate((Quaternionfc)new Quaternionf().setAngleAxis((double)angle * Math.PI / 180.0, upVector.f_82479_, upVector.f_82480_, upVector.f_82481_));
                    spit.m_6686_(targetVector.x(), targetVector.y(), targetVector.z(), velocity, inaccuracy);
                    EntityModifierCapability.getCapability((Entity)spit).setModifiers(tool.getModifiers());
                    ModDataNBT arrowData = PersistentDataCapability.getOrWarn((Entity)spit);
                    for (ModifierEntry entry : tool.getModifierList()) {
                        entry.getHook(ModifierHooks.PROJECTILE_LAUNCH).onProjectileLaunch(tool, entry, entity, ItemStack.f_41583_, spit, null, arrowData, shotIndex == primaryIndex);
                    }
                    world.m_7967_((Entity)spit);
                    world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Sounds.SPIT.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f / (world.m_213780_().m_188501_() * 0.4f + 1.2f) + charge * 0.5f + angle / 10.0f);
                }
                fluid.shrink(amount * shots);
                ToolTankHelper.TANK_HELPER.setFluid(tool, fluid);
                ToolDamageUtil.damageAnimated(tool, shots, entity, entity.m_7655_());
            }
        }
    }
}

