/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function7;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.ToolActions;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public interface CounterModule
extends ModifierModule,
OnAttackedModifierHook,
ModifierCondition.ConditionalModule<IToolStackView> {
    public static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.ON_ATTACKED);
    public static final LoadableField<LevelingValue, CounterModule> CHANCE_FIELD = LevelingValue.LOADABLE.requiredField("chance", CounterModule::chance);
    public static final LoadableField<Integer, CounterModule> DURABILITY_FIELD = IntLoadable.FROM_ZERO.requiredField("durability_usage", CounterModule::durabilityUsage);
    public static final LoadableField<IJsonPredicate<LivingEntity>, CounterModule> DEFENDER_FIELD = LivingEntityPredicate.LOADER.defaultField("defender", CounterModule::defender);
    public static final LoadableField<IJsonPredicate<LivingEntity>, CounterModule> ATTACKER_FIELD = LivingEntityPredicate.LOADER.defaultField("attacker", CounterModule::attacker);

    @Override
    default public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public LevelingValue chance();

    public LevelingValue constant();

    public LevelingValue random();

    public int durabilityUsage();

    default public IJsonPredicate<LivingEntity> defender() {
        return LivingEntityPredicate.ANY;
    }

    default public IJsonPredicate<LivingEntity> attacker() {
        return LivingEntityPredicate.ANY;
    }

    default public boolean checkChance(float level) {
        float chance = this.chance().compute(level);
        if (chance <= 0.0f) {
            return false;
        }
        if (chance >= 1.0f) {
            return true;
        }
        return TConstruct.RANDOM.nextFloat() < chance;
    }

    default public boolean canApply(Entity target) {
        return true;
    }

    public void applyEffect(IToolStackView var1, ModifierEntry var2, float var3, EquipmentContext var4, Entity var5, DamageSource var6, float var7);

    @Override
    default public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float damageDealt, boolean isDirectDamage) {
        float value;
        float level;
        Entity attacker = source.m_7639_();
        LivingEntity defender = context.getEntity();
        if (isDirectDamage && attacker != null && this.canApply(attacker) && TinkerPredicate.matches(this.attacker(), attacker) && this.defender().matches((Object)defender) && this.condition().matches(tool, modifier) && this.checkChance(level = CounterModule.getLevel(tool, modifier, slotType, defender)) && (value = LevelingValue.applyRandom(level, this.constant(), this.random())) > 0.0f) {
            this.applyEffect(tool, modifier, value, context, attacker, source, damageDealt);
            int durabilityUsage = this.durabilityUsage();
            if (durabilityUsage > 0) {
                ToolDamageUtil.damageAnimated(tool, durabilityUsage, defender, slotType, true);
            }
        }
    }

    public static boolean isBlocking(IToolStackView tool, EquipmentSlot slotType, LivingEntity holder) {
        return slotType.m_20743_() == EquipmentSlot.Type.HAND && holder.m_6117_() && Util.getSlotType(holder.m_7655_()) == slotType && ModifierUtil.canPerformAction(tool, ToolActions.SHIELD_BLOCK) && holder.m_6844_(slotType).m_41779_() - holder.m_21212_() >= 5;
    }

    public static float getLevel(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slotType, LivingEntity defender) {
        float level = modifier.getEffectiveLevel();
        if (CounterModule.isBlocking(tool, slotType, defender)) {
            level *= 2.0f;
        }
        return level;
    }

    @Deprecated(forRemoval=true)
    public static <T extends CounterModule> RecordLoadable<T> makeLoader(String value, Function5<LevelingValue, LevelingValue, LevelingValue, Integer, ModifierCondition<IToolStackView>, T> constructor) {
        return RecordLoadable.create(CHANCE_FIELD, (RecordField)LevelingValue.LOADABLE.defaultField("constant_" + value, (Object)LevelingValue.ZERO, CounterModule::constant), (RecordField)LevelingValue.LOADABLE.defaultField("random_" + value, (Object)LevelingValue.ZERO, CounterModule::random), DURABILITY_FIELD, ModifierCondition.TOOL_FIELD, constructor);
    }

    public static <T extends CounterModule> RecordLoadable<T> makeLoader(String value, Function7<LevelingValue, LevelingValue, LevelingValue, Integer, IJsonPredicate<LivingEntity>, IJsonPredicate<LivingEntity>, ModifierCondition<IToolStackView>, T> constructor) {
        return RecordLoadable.create(CHANCE_FIELD, (RecordField)LevelingValue.LOADABLE.defaultField("constant_" + value, (Object)LevelingValue.ZERO, CounterModule::constant), (RecordField)LevelingValue.LOADABLE.defaultField("random_" + value, (Object)LevelingValue.ZERO, CounterModule::random), DURABILITY_FIELD, DEFENDER_FIELD, ATTACKER_FIELD, ModifierCondition.TOOL_FIELD, constructor);
    }

    public static class Builder<T>
    extends ModuleBuilder.Stack<Builder<T>> {
        private final Function7<LevelingValue, LevelingValue, LevelingValue, Integer, IJsonPredicate<LivingEntity>, IJsonPredicate<LivingEntity>, ModifierCondition<IToolStackView>, T> constructor;
        private LevelingValue chance = LevelingValue.eachLevel(0.15f);
        private LevelingValue constant = LevelingValue.ZERO;
        private LevelingValue random = LevelingValue.ZERO;
        private int durabilityUsage = 1;
        private IJsonPredicate<LivingEntity> defender = LivingEntityPredicate.ANY;
        private IJsonPredicate<LivingEntity> attacker = LivingEntityPredicate.ANY;

        @Deprecated(forRemoval=true)
        public Builder(Function5<LevelingValue, LevelingValue, LevelingValue, Integer, ModifierCondition<IToolStackView>, T> constructor) {
            this((chance, constant, random, durability, defender, attacker, condition) -> constructor.apply(chance, constant, random, durability, condition));
        }

        public Builder<T> chanceLeveling(float value) {
            return this.chance(LevelingValue.eachLevel(value));
        }

        public Builder<T> constantFlat(float value) {
            return this.constant(LevelingValue.flat(value));
        }

        public Builder<T> randomFlat(float value) {
            return this.random(LevelingValue.flat(value));
        }

        public T build() {
            return (T)this.constructor.apply((Object)this.chance, (Object)this.constant, (Object)this.random, (Object)this.durabilityUsage, this.defender, this.attacker, (Object)this.condition);
        }

        public Builder(Function7<LevelingValue, LevelingValue, LevelingValue, Integer, IJsonPredicate<LivingEntity>, IJsonPredicate<LivingEntity>, ModifierCondition<IToolStackView>, T> constructor) {
            this.constructor = constructor;
        }

        public Builder<T> chance(LevelingValue chance) {
            this.chance = chance;
            return this;
        }

        public Builder<T> constant(LevelingValue constant) {
            this.constant = constant;
            return this;
        }

        public Builder<T> random(LevelingValue random) {
            this.random = random;
            return this;
        }

        public Builder<T> durabilityUsage(int durabilityUsage) {
            this.durabilityUsage = durabilityUsage;
            return this;
        }

        public Builder<T> defender(IJsonPredicate<LivingEntity> defender) {
            this.defender = defender;
            return this;
        }

        public Builder<T> attacker(IJsonPredicate<LivingEntity> attacker) {
            this.attacker = attacker;
            return this;
        }
    }
}

