/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;

public class Schedule {
    public static final Schedule EMPTY = new Schedule(new ScheduleEntry[0]);
    private final ScheduleEntry[] entries;
    private int nextIndex = 0;

    public boolean isEmpty() {
        return this.nextIndex >= this.entries.length;
    }

    public int check(int time) {
        if (this.nextIndex < this.entries.length) {
            ScheduleEntry nextEntry = this.entries[this.nextIndex];
            if (time >= nextEntry.time) {
                ++this.nextIndex;
                return nextEntry.task;
            }
        }
        return -1;
    }

    public static int index(int task, int size) {
        return task % size;
    }

    public static int local(int task, int size) {
        return task / size;
    }

    public ListTag serialize() {
        ListTag list = new ListTag();
        for (int i = this.nextIndex; i < this.entries.length; ++i) {
            list.add((Object)this.entries[i].serialize());
        }
        return list;
    }

    public static Schedule deserialize(ListTag list) {
        if (list.isEmpty()) {
            return EMPTY;
        }
        ScheduleEntry[] entries = new ScheduleEntry[list.size()];
        for (int i = 0; i < entries.length; ++i) {
            entries[i] = ScheduleEntry.deserialize(list.m_128728_(i));
        }
        return new Schedule(entries);
    }

    public Schedule(ScheduleEntry[] entries) {
        this.entries = entries;
    }

    private record ScheduleEntry(int task, int time) {
        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("task", this.task);
            tag.m_128405_("time", this.time);
            return tag;
        }

        public static ScheduleEntry deserialize(CompoundTag nbt) {
            return new ScheduleEntry(nbt.m_128451_("task"), nbt.m_128451_("time"));
        }
    }

    public static class ListScheduler
    implements Scheduler {
        private final Scheduler parent;
        private final int size;
        private int index;

        @Override
        public Scheduler add(int task, int time) {
            return this.parent.add(task * this.size + this.index, time);
        }

        private ListScheduler(Scheduler parent, int size) {
            this.parent = parent;
            this.size = size;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static class ScheduleBuilder
    implements Scheduler {
        private final List<ScheduleEntry> entries = new ArrayList<ScheduleEntry>();

        @Override
        public Scheduler add(int task, int time) {
            if (task < 0) {
                throw new IllegalArgumentException("Task must be non-negative");
            }
            this.entries.add(new ScheduleEntry(task, time));
            return this;
        }

        public Schedule build() {
            return new Schedule((ScheduleEntry[])this.entries.stream().sorted(Comparator.comparing(ScheduleEntry::time)).toArray(ScheduleEntry[]::new));
        }
    }

    public static interface Scheduler {
        public Scheduler add(int var1, int var2);

        default public ListScheduler list(int size) {
            return new ListScheduler(this, size);
        }
    }
}

