/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionLoader;

public class UpdateToolDefinitionDataPacket
implements IThreadsafePacket {
    private final Map<ResourceLocation, ToolDefinitionData> dataMap;

    public UpdateToolDefinitionDataPacket(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            ResourceLocation name = buffer.m_130281_();
            ToolDefinitionData data = (ToolDefinitionData)ToolDefinitionData.LOADABLE.decode(buffer, ToolDefinitionLoader.contextBuilder(name).build());
            builder.put((Object)name, (Object)data);
        }
        this.dataMap = builder.build();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.dataMap.size());
        for (Map.Entry<ResourceLocation, ToolDefinitionData> entry : this.dataMap.entrySet()) {
            buffer.m_130085_(entry.getKey());
            ToolDefinitionData.LOADABLE.encode(buffer, (Object)entry.getValue());
        }
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        ToolDefinitionLoader.getInstance().updateDataFromServer(this.dataMap);
    }

    public UpdateToolDefinitionDataPacket(Map<ResourceLocation, ToolDefinitionData> dataMap) {
        this.dataMap = dataMap;
    }

    protected Map<ResourceLocation, ToolDefinitionData> getDataMap() {
        return this.dataMap;
    }
}

