/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.modules.capacity.OverslimeModule;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeModifierRecipe
implements ITinkerStationRecipe,
IDisplayModifierRecipe {
    private static final RecipeResult<LazyToolStack> AT_CAPACITY = RecipeResult.failure(TConstruct.makeTranslationKey("recipe", "overslime.at_capacity"), new Object[0]);
    public static final RecordLoadable<OverslimeModifierRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)IngredientLoadable.DISALLOW_EMPTY.defaultField("tools", (Object)Ingredient.m_204132_(TinkerTags.Items.DURABILITY), true, r -> r.tools), (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", r -> r.ingredient), (RecordField)IntLoadable.FROM_ONE.requiredField("restore_amount", r -> r.restoreAmount), OverslimeModifierRecipe::new);
    private final ResourceLocation id;
    private final Ingredient tools;
    private final Ingredient ingredient;
    private final int restoreAmount;
    private static final ModifierEntry RESULT = new ModifierEntry(TinkerModifiers.overslime, 1);
    private List<ItemStack> toolWithoutModifier;
    private List<ItemStack> toolWithModifier = null;

    @ApiStatus.Internal
    protected OverslimeModifierRecipe(ResourceLocation id, Ingredient tools, Ingredient ingredient, int restoreAmount) {
        this.id = id;
        this.tools = tools;
        this.ingredient = ingredient;
        this.restoreAmount = restoreAmount;
        ModifierRecipeLookup.addRecipeModifier(null, TinkerModifiers.overslime);
    }

    @Deprecated(forRemoval=true)
    public OverslimeModifierRecipe(ResourceLocation id, Ingredient ingredient, int restoreAmount) {
        this(id, Ingredient.m_204132_(TinkerTags.Items.DURABILITY), ingredient, restoreAmount);
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!this.tools.test(inv.getTinkerableStack())) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        ToolStack tool = inv.getTinkerable();
        ModifierId overslime = TinkerModifiers.overslime.getId();
        if (tool.getUpgrades().getLevel(overslime) == 0) {
            if (tool.getModifierLevel(overslime) > 0 && OverslimeModule.INSTANCE.getAmount(tool) >= OverslimeModule.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
            tool.addModifier(overslime, 1);
        } else {
            if (OverslimeModule.INSTANCE.getAmount(tool) >= OverslimeModule.getCapacity(tool)) {
                return AT_CAPACITY;
            }
            tool = tool.copy();
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, this.restoreAmount);
        OverslimeModule.INSTANCE.addAmount(tool, available);
        return ITinkerStationRecipe.success(tool, inv);
    }

    @Override
    public void updateInputs(LazyToolStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = inv.getTinkerable();
        int maxNeeded = OverslimeModule.INSTANCE.getAmount(result.getTool()) - OverslimeModule.INSTANCE.getAmount(tool);
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, maxNeeded, this.restoreAmount * OverslimeModule.getOverworkedBonus(tool), ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.overslimeSerializer.get();
    }

    @Override
    @Nullable
    public ResourceLocation getRecipeId() {
        return this.m_6423_();
    }

    @Override
    public int getInputCount() {
        return 1;
    }

    @Override
    public List<ItemStack> getDisplayItems(int slot) {
        if (slot == 0) {
            return Arrays.asList(this.ingredient.m_43908_());
        }
        return Collections.emptyList();
    }

    @Override
    public List<ItemStack> getToolWithoutModifier() {
        if (this.toolWithoutModifier == null) {
            this.toolWithoutModifier = Arrays.stream(this.tools.m_43908_()).map(MAP_TOOL_STACK_FOR_RENDERING).toList();
        }
        return this.toolWithoutModifier;
    }

    @Override
    public List<ItemStack> getToolWithModifier() {
        if (this.toolWithModifier == null) {
            List<ModifierEntry> result = List.of(RESULT);
            int maxSize = this.shrinkToolSlotBy();
            this.toolWithModifier = Arrays.stream(this.tools.m_43908_()).map(MAP_TOOL_STACK_FOR_RENDERING).map(stack -> IDisplayModifierRecipe.withModifiers(stack, maxSize, result, data -> OverslimeModule.INSTANCE.setAmountRaw((ModDataNBT)data, this.restoreAmount))).toList();
        }
        return this.toolWithModifier;
    }

    @Override
    public ModifierEntry getDisplayResult() {
        return RESULT;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }
}

