/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.ShapedMaterialsRecipe;
import slimeknights.tconstruct.tables.TinkerTables;

public class MaterialsConsumerBuilder {
    private final String parts;
    private final int partCount;
    private final List<MaterialVariantId> materials = new ArrayList<MaterialVariantId>();

    public static MaterialsConsumerBuilder shaped(String parts) {
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Parts may not be empty");
        }
        return new MaterialsConsumerBuilder(parts, 0);
    }

    public static MaterialsConsumerBuilder shapeless(int parts) {
        if (parts <= 0) {
            throw new IllegalArgumentException("Parts must be greater than 0");
        }
        return new MaterialsConsumerBuilder("", parts);
    }

    public MaterialsConsumerBuilder material(MaterialVariantId material) {
        this.materials.add(material);
        return this;
    }

    public Consumer<FinishedRecipe> build(Consumer<FinishedRecipe> consumer) {
        return recipe -> consumer.accept(new Wrapped((FinishedRecipe)recipe, this.materials, this.parts, this.partCount));
    }

    private MaterialsConsumerBuilder(String parts, int partCount) {
        this.parts = parts;
        this.partCount = partCount;
    }

    private record Wrapped(FinishedRecipe original, List<MaterialVariantId> materials, String parts, int partCount) implements FinishedRecipe
    {
        public ResourceLocation m_6445_() {
            return this.original.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.partCount > 0 ? (RecipeSerializer)TinkerTables.shapelessMaterialsRecipeSerializer.get() : (RecipeSerializer)TinkerTables.shapedMaterialsRecipeSerializer.get();
        }

        public void m_7917_(JsonObject json) {
            this.original.m_7917_(json);
            if (!this.materials.isEmpty()) {
                json.add(ShapedMaterialsRecipe.Serializer.MATERIAL_FIELD.key(), ShapedMaterialsRecipe.Serializer.EXTRA_MATERIALS.serialize(this.materials));
            }
            if (!this.parts.isEmpty()) {
                json.addProperty("parts", this.parts);
            } else {
                json.addProperty("parts", (Number)this.partCount);
            }
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.original.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.original.m_6448_();
        }
    }
}

