/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.data.material.AbstractMaterialDataProvider;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.json.MaterialStatJson;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.tools.modules.ArmorModuleBuilder;

public abstract class AbstractMaterialStatsDataProvider
extends GenericDataProvider {
    private final Map<MaterialId, MaterialStats> allMaterialStats = new HashMap<MaterialId, MaterialStats>();
    private final AbstractMaterialDataProvider materials;

    public AbstractMaterialStatsDataProvider(PackOutput packOutput, AbstractMaterialDataProvider materials) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/materials/stats");
        this.materials = materials;
    }

    protected abstract void addMaterialStats();

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addMaterialStats();
        Set<MaterialId> materialsGenerated = this.materials.getAllMaterials();
        for (MaterialId material : materialsGenerated) {
            if (this.allMaterialStats.containsKey(material)) continue;
            throw new IllegalStateException(String.format("Missing material stats for '%s'", material));
        }
        return AbstractMaterialStatsDataProvider.allOf(this.allMaterialStats.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((MaterialStats)entry.getValue()).serialize())));
    }

    private MaterialStats getStats(MaterialId material) {
        return this.allMaterialStats.computeIfAbsent(material, id -> new MaterialStats(new ArrayList<IMaterialStats>(), new ArrayList<IMaterialStats>()));
    }

    protected void addMaterialStats(MaterialId location, IMaterialStats ... stats) {
        Collections.addAll(this.getStats((MaterialId)location).required, stats);
    }

    protected void addOptionalStats(MaterialId location, IMaterialStats ... stats) {
        Collections.addAll(this.getStats((MaterialId)location).optional, stats);
    }

    protected void addArmorStats(MaterialId location, ArmorModuleBuilder<? extends IMaterialStats> statBuilder, IMaterialStats ... otherStats) {
        IMaterialStats[] stats = new IMaterialStats[4];
        for (ArmorItem.Type slotType : ArmorItem.Type.values()) {
            stats[slotType.ordinal()] = statBuilder.build(slotType);
        }
        this.addMaterialStats(location, stats);
        if (otherStats.length > 0) {
            this.addMaterialStats(location, otherStats);
        }
    }

    protected void addArmorShieldStats(MaterialId location, ArmorModuleBuilder.ArmorShieldModuleBuilder<? extends IMaterialStats> statBuilder, IMaterialStats ... otherStats) {
        this.addArmorStats(location, statBuilder, otherStats);
        this.addMaterialStats(location, statBuilder.buildShield());
    }

    private record MaterialStats(List<IMaterialStats> required, List<IMaterialStats> optional) {
        private static <T extends IMaterialStats> JsonObject encodeStats(IMaterialStats stats, MaterialStatType<T> type) {
            JsonObject json = new JsonObject();
            type.getLoadable().serialize((Object)stats, json);
            return json;
        }

        public MaterialStatJson serialize() {
            HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
            for (IMaterialStats stat : this.required) {
                map.put(stat.getIdentifier(), (JsonElement)MaterialStats.encodeStats(stat, stat.getType()));
            }
            for (IMaterialStats stat : this.optional) {
                JsonObject encoded = MaterialStats.encodeStats(stat, stat.getType());
                encoded.addProperty("optional", Boolean.valueOf(true));
                map.put(stat.getIdentifier(), (JsonElement)encoded);
            }
            return new MaterialStatJson(map);
        }
    }
}

