/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.combat;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.Tags;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ProcessLootModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipeCache;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public enum SeveringModule implements ModifierModule,
ProcessLootModifierHook
{
    INSTANCE;

    private static final List<ModuleHook<?>> DEFAULT_HOOKS;
    public static final RecordLoadable<SeveringModule> LOADER;

    public RecordLoadable<SeveringModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void processLoot(IToolStackView tool, ModifierEntry modifier, List<ItemStack> generatedLoot, LootContext context) {
        ServerLevel world;
        List<SeveringRecipe> recipes;
        if (!context.m_78936_(LootContextParams.f_81457_)) {
            return;
        }
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (entity != null && generatedLoot.stream().noneMatch(stack -> stack.m_204117_(Tags.Items.HEADS)) && !(recipes = SeveringRecipeCache.findRecipe((world = context.m_78952_()).m_7465_(), entity.m_6095_())).isEmpty()) {
            float level = modifier.getEffectiveLevel();
            float looting = context.getLootingModifier();
            float chanceMultiplier = entity.m_6095_().m_204039_(TinkerTags.EntityTypes.RARE_MOBS) ? 2.0f : 1.0f;
            for (SeveringRecipe recipe : recipes) {
                ItemStack result;
                if (!(world.f_46441_.m_188501_() < recipe.getChance(level, looting) * chanceMultiplier) || (result = recipe.getOutput(entity)).m_41619_()) continue;
                if (result.m_41613_() > 1) {
                    result.m_41764_(world.f_46441_.m_188503_(result.m_41613_()) + 1);
                }
                generatedLoot.add(result);
            }
        }
    }

    static {
        DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROCESS_LOOT);
        LOADER = new SingletonLoader((Object)INSTANCE);
    }
}

