/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.technical.SlotInChargeModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.stats.ToolType;

public record RecurrentProtectionModule(LevelingValue percent, LevelingInt duration) implements ModifierModule,
ModifyDamageModifierHook,
TooltipModifierHook
{
    private static final Component PROTECTION = TConstruct.makeTranslation("modifier", "recurrent_protection.resistance");
    private static final TinkerDataCapability.TinkerDataKey<SlotInChargeModule.SlotInCharge> SLOT_KEY = TConstruct.createKey("momentum");
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MODIFY_HURT, ModifierHooks.TOOLTIP);
    public static final RecordLoadable<RecurrentProtectionModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("percent", RecurrentProtectionModule::percent), (RecordField)LevelingInt.LOADABLE.requiredField("duration", RecurrentProtectionModule::duration), RecurrentProtectionModule::new);

    public RecordLoadable<RecurrentProtectionModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addModules(ModuleHookMap.Builder builder) {
        builder.addModule(new SlotInChargeModule(SLOT_KEY));
    }

    @Override
    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        int level;
        if (!source.m_269533_(DamageTypeTags.f_268738_) && (level = SlotInChargeModule.getLevel(context.getTinkerData(), SLOT_KEY, slotType)) > 0) {
            MobEffect effect = (MobEffect)TinkerModifiers.momentumEffect.get((Enum)ToolType.ARMOR);
            LivingEntity entity = context.getEntity();
            int reduction = (int)(this.percent.compute(level) * (amount -= (float)TinkerEffect.getLevel(entity, effect)));
            if (reduction > 0) {
                entity.m_7292_(new MobEffectInstance(effect, this.duration.compute(level), reduction - 1, false, false, true));
            }
        }
        return amount;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        if (player == null || tooltipKey != TooltipKey.SHIFT) {
            TooltipModifierHook.addPercentBoost(modifier.getModifier(), PROTECTION, this.percent.compute(modifier.getLevel()), tooltip);
        } else {
            int level = TinkerEffect.getLevel((LivingEntity)player, (MobEffect)TinkerModifiers.momentumEffect.get((Enum)ToolType.ARMOR));
            if (level > 0) {
                TooltipModifierHook.addFlatBoost(modifier.getModifier(), PROTECTION, this.percent.compute(modifier.getLevel()), tooltip);
            }
        }
    }
}

