/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.armor;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.damage.DamageSourcePredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.tconstruct.library.json.LevelingValue;
import slimeknights.tconstruct.library.json.predicate.TinkerPredicate;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.armor.ModifyDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.modifiers.modules.util.ModuleBuilder;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record FlatReductionModule(LevelingValue reduction, LevelingValue minimum, IJsonPredicate<LivingEntity> holder, IJsonPredicate<DamageSource> damageSource, ModifierCondition<IToolStackView> condition) implements ModifierModule,
ModifyDamageModifierHook,
TooltipModifierHook,
ModifierCondition.ConditionalModule<IToolStackView>
{
    public static final RecordLoadable<FlatReductionModule> LOADER = RecordLoadable.create((RecordField)LevelingValue.LOADABLE.requiredField("reduction", FlatReductionModule::reduction), (RecordField)LevelingValue.LOADABLE.requiredField("minimum", FlatReductionModule::minimum), (RecordField)LivingEntityPredicate.LOADER.defaultField("holder", FlatReductionModule::holder), (RecordField)DamageSourcePredicate.LOADER.defaultField("damage_source", FlatReductionModule::damageSource), ModifierCondition.TOOL_FIELD, FlatReductionModule::new);

    @Override
    public RecordLoadable<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return List.of();
    }

    @Override
    public float modifyDamageTaken(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        float level;
        float minimum;
        if (this.condition.matches(tool, modifier) && this.holder.matches((Object)context.getEntity()) && this.damageSource.matches((Object)source) && amount > (minimum = this.minimum.compute(level = modifier.getEffectiveLevel()))) {
            amount = Math.max(minimum, amount - this.reduction.compute(level));
        }
        return amount;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float reduction;
        if (this.condition.matches(tool, entry) && TinkerPredicate.matchesInTooltip(this.holder, (LivingEntity)player, tooltipKey) && (reduction = this.reduction.compute(entry.getEffectiveLevel())) != 0.0f) {
            Modifier modifier = entry.getModifier();
            TooltipModifierHook.addFlatBoost(modifier, (Component)Component.m_237115_((String)(modifier.getTranslationKey() + ".reduction")), reduction, tooltip);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ModuleBuilder.Stack<Builder>
    implements LevelingValue.Builder<FlatReductionModule> {
        private LevelingValue minimum = LevelingValue.ZERO;
        private IJsonPredicate<LivingEntity> holder = LivingEntityPredicate.ANY;
        private IJsonPredicate<DamageSource> damageSource = DamageSourcePredicate.CAN_PROTECT;

        @Override
        public FlatReductionModule amount(float flat, float eachLevel) {
            return new FlatReductionModule(new LevelingValue(flat, eachLevel), this.minimum, this.holder, this.damageSource, this.condition);
        }

        public Builder minimum(LevelingValue minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder holder(IJsonPredicate<LivingEntity> holder) {
            this.holder = holder;
            return this;
        }

        public Builder damageSource(IJsonPredicate<DamageSource> damageSource) {
            this.damageSource = damageSource;
            return this;
        }
    }
}

