/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;
import slimeknights.tconstruct.smeltery.network.SmelteryTankUpdatePacket;

public class SmelteryTank<T extends MantleBlockEntity>
implements IFluidHandler {
    private final T parent;
    private final List<FluidStack> fluids = Lists.newArrayList();
    private int capacity = 0;
    private int contained = 0;
    private static final String TAG_FLUIDS = "fluids";
    private static final String TAG_CAPACITY = "capacity";

    public SmelteryTank(T parent) {
        this.parent = parent;
    }

    public void syncFluids() {
        Level world = this.parent.m_58904_();
        if (world != null && !world.f_46443_) {
            BlockPos pos = this.parent.m_58899_();
            TinkerNetwork.getInstance().sendToClientsAround(new SmelteryTankUpdatePacket(pos, this.fluids), (LevelAccessor)world, pos);
        }
    }

    public void setCapacity(int maxCapacity) {
        this.capacity = maxCapacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getRemainingSpace() {
        if (this.contained >= this.capacity) {
            return 0;
        }
        return this.capacity - this.contained;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int getTanks() {
        if (this.contained < this.capacity) {
            return this.fluids.size() + 1;
        }
        return this.fluids.size();
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (tank < 0 || tank >= this.fluids.size()) {
            return FluidStack.EMPTY;
        }
        return this.fluids.get(tank);
    }

    public int getTankCapacity(int tank) {
        if (tank < 0) {
            return 0;
        }
        int remaining = this.capacity - this.contained;
        if (tank == this.fluids.size()) {
            return remaining;
        }
        return this.fluids.get(tank).getAmount() + remaining;
    }

    public void moveFluidToBottom(int index) {
        if (index < this.fluids.size()) {
            FluidStack fluid = this.fluids.get(index);
            this.fluids.remove(index);
            this.fluids.add(0, fluid);
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, FluidStack.EMPTY);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.contained >= this.capacity || resource.isEmpty()) {
            return 0;
        }
        int usable = Math.min(this.capacity - this.contained, resource.getAmount());
        if (usable <= 0) {
            return 0;
        }
        if (action.simulate()) {
            return usable;
        }
        this.contained += usable;
        for (FluidStack fluid : this.fluids) {
            if (!fluid.isFluidEqual(resource)) continue;
            fluid.grow(usable);
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
            return usable;
        }
        resource = resource.copy();
        resource.setAmount(usable);
        this.fluids.add(resource);
        ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ADDED, resource);
        return usable;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.fluids.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack fluid = this.fluids.get(0);
        int drainable = Math.min(maxDrain, fluid.getAmount());
        FluidStack ret = fluid.copy();
        ret.setAmount(drainable);
        if (action.execute()) {
            fluid.shrink(drainable);
            this.contained -= drainable;
            if (fluid.getAmount() <= 0) {
                this.fluids.remove(fluid);
                ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, fluid);
            } else {
                ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
            }
        }
        return ret;
    }

    @Nonnull
    public FluidStack drain(FluidStack toDrain, IFluidHandler.FluidAction action) {
        ListIterator<FluidStack> iter = this.fluids.listIterator();
        while (iter.hasNext()) {
            FluidStack fluid = iter.next();
            if (!fluid.isFluidEqual(toDrain)) continue;
            int drainable = Math.min(toDrain.getAmount(), fluid.getAmount());
            FluidStack ret = fluid.copy();
            ret.setAmount(drainable);
            if (action.execute()) {
                fluid.shrink(drainable);
                this.contained -= drainable;
                if (fluid.getAmount() <= 0) {
                    iter.remove();
                    ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.REMOVED, fluid);
                } else {
                    ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.CHANGED, fluid);
                }
            }
            return ret;
        }
        return FluidStack.EMPTY;
    }

    public void setFluids(List<FluidStack> fluids) {
        FluidStack oldFirst = this.getFluidInTank(0);
        this.fluids.clear();
        this.fluids.addAll(fluids);
        this.contained = fluids.stream().mapToInt(FluidStack::getAmount).reduce(0, Integer::sum);
        FluidStack newFirst = this.getFluidInTank(0);
        if (!oldFirst.isFluidEqual(newFirst)) {
            ((ISmelteryTankHandler)this.parent).notifyFluidsChanged(ISmelteryTankHandler.FluidChange.ORDER_CHANGED, newFirst);
        }
    }

    public CompoundTag write(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (FluidStack liquid : this.fluids) {
            CompoundTag fluidTag = new CompoundTag();
            liquid.writeToNBT(fluidTag);
            list.add((Object)fluidTag);
        }
        nbt.m_128365_(TAG_FLUIDS, (Tag)list);
        nbt.m_128405_(TAG_CAPACITY, this.capacity);
        return nbt;
    }

    public void read(CompoundTag tag) {
        ListTag list = tag.m_128437_(TAG_FLUIDS, 10);
        this.fluids.clear();
        this.contained = 0;
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag fluidTag = list.m_128728_(i);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)fluidTag);
            if (fluid.isEmpty()) continue;
            this.fluids.add(fluid);
            this.contained += fluid.getAmount();
        }
        this.capacity = tag.m_128451_(TAG_CAPACITY);
    }

    public List<FluidStack> getFluids() {
        return this.fluids;
    }

    public int getContained() {
        return this.contained;
    }
}

