/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.behavior;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.data.loadable.common.ItemStackLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.primitive.StringLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.BowAmmoModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public record InfinityModule(ItemStack ammo, String variantTag, int durabilityUsage, boolean checkStandardArrows) implements ModifierModule,
BowAmmoModifierHook,
ModifierRemovalHook,
ProjectileLaunchModifierHook.NoShooter
{
    private static final String INFINITY = "tic_infinity";
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.BOW_AMMO, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.PROJECTILE_SHOT, ModifierHooks.REMOVE);
    public static final RecordLoadable<InfinityModule> LOADER = RecordLoadable.create((RecordField)ItemStackLoadable.REQUIRED_ITEM_NBT.requiredField("ammo", InfinityModule::ammo), (RecordField)StringLoadable.DEFAULT.defaultField("variant_tag", (Object)"", InfinityModule::variantTag), (RecordField)IntLoadable.FROM_ZERO.requiredField("durability_usage", InfinityModule::durabilityUsage), (RecordField)BooleanLoadable.INSTANCE.defaultField("check_standard_arrows", Boolean.valueOf(true), InfinityModule::checkStandardArrows), InfinityModule::new);

    public RecordLoadable<InfinityModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public ItemStack findAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack standardAmmo, Predicate<ItemStack> ammoPredicate) {
        String variant;
        if (this.checkStandardArrows && !standardAmmo.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int count = this.durabilityUsage <= 0 ? 64 : Math.min(64, (tool.getCurrentDurability() + this.durabilityUsage - 1) / this.durabilityUsage);
        ItemStack ammo = this.ammo.m_255036_(count);
        CompoundTag tag = ammo.m_41784_();
        tag.m_128379_(INFINITY, true);
        if (!this.variantTag.isEmpty() && !(variant = tool.getPersistentData().getString(modifier.getId())).isEmpty()) {
            tag.m_128359_(this.variantTag, variant);
        }
        return ammo;
    }

    @Override
    public void onProjectileShoot(IToolStackView tool, ModifierEntry modifier, @Nullable LivingEntity shooter, ItemStack ammo, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        CompoundTag tag;
        if (arrow != null && arrow.f_36705_ != AbstractArrow.Pickup.CREATIVE_ONLY && (tag = ammo.m_41783_()) != null && tag.m_128471_(INFINITY)) {
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }

    @Override
    public void shrinkAmmo(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, ItemStack ammo, int needed) {
        if (this.durabilityUsage > 0) {
            ToolDamageUtil.damageAnimated(tool, this.durabilityUsage * needed, shooter, shooter.m_7655_(), true);
        }
    }

    @Override
    @Nullable
    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        if (!this.variantTag.isEmpty()) {
            tool.getPersistentData().remove(modifier.getId());
        }
        return null;
    }
}

