/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.data.tinkering;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayoutLoader;

public abstract class AbstractStationSlotLayoutProvider
extends GenericDataProvider {
    protected static final int SORT_WEAPON = 3;
    protected static final int SORT_HARVEST = 6;
    protected static final int SORT_AMMO = 7;
    protected static final int SORT_RANGED = 8;
    protected static final int SORT_LARGE = 6;
    protected static final int SORT_ARMOR = 15;
    private final Map<ResourceLocation, SerializeLayout> allLayouts = new HashMap<ResourceLocation, SerializeLayout>();

    public AbstractStationSlotLayoutProvider(PackOutput packOutput) {
        super(packOutput, PackOutput.Target.DATA_PACK, "tinkering/station_layouts", StationSlotLayoutLoader.GSON);
    }

    protected abstract void addLayouts();

    protected StationSlotLayout.Builder define(ResourceLocation id) {
        return this.allLayouts.computeIfAbsent((ResourceLocation)id, (Function<ResourceLocation, SerializeLayout>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$define$0(net.minecraft.resources.ResourceLocation ), (Lnet/minecraft/resources/ResourceLocation;)Lslimeknights/tconstruct/library/data/tinkering/AbstractStationSlotLayoutProvider$SerializeLayout;)()).builder;
    }

    protected StationSlotLayout.Builder define(ResourceLocation id, ICondition ... conditions) {
        SerializeLayout layout = this.allLayouts.computeIfAbsent(id, i -> new SerializeLayout());
        Collections.addAll(layout.conditions, conditions);
        return layout.builder;
    }

    protected StationSlotLayout.Builder define(ItemLike item) {
        return this.define(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()));
    }

    protected StationSlotLayout.Builder definePattern(Pattern id) {
        return this.define(id).icon(id);
    }

    protected StationSlotLayout.Builder defineModifiable(IModifiableDisplay item) {
        return this.define(BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_())).translationKey(item.m_5456_().m_5524_()).icon(item.getRenderTool());
    }

    protected StationSlotLayout.Builder defineModifiable(Supplier<? extends IModifiableDisplay> item) {
        return this.defineModifiable(item.get());
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addLayouts();
        return AbstractStationSlotLayoutProvider.allOf(this.allLayouts.entrySet().stream().map(entry -> this.saveJson(cache, (ResourceLocation)entry.getKey(), ((SerializeLayout)entry.getValue()).serialize())));
    }

    private static /* synthetic */ SerializeLayout lambda$define$0(ResourceLocation i) {
        return new SerializeLayout();
    }

    private record SerializeLayout(StationSlotLayout.Builder builder, List<ICondition> conditions) {
        public SerializeLayout() {
            this(StationSlotLayout.builder(), new ArrayList<ICondition>());
        }

        public JsonObject serialize() {
            JsonObject json = StationSlotLayoutLoader.GSON.toJsonTree((Object)this.builder.build()).getAsJsonObject();
            if (!this.conditions.isEmpty()) {
                json.add("conditions", (JsonElement)CraftingHelper.serialize((ICondition[])((ICondition[])this.conditions.toArray(ICondition[]::new))));
            }
            return json;
        }
    }
}

