/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.recipe;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.IntRange;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.RecipeResult;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierRecipeLookup;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.library.tools.nbt.LazyToolStack;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modules.cosmetic.TrimModule;

public class ArmorTrimRecipe
implements ITinkerStationRecipe,
IMultiRecipe<IDisplayModifierRecipe> {
    protected static final String KEY_INVALID_MATERIAL = TConstruct.makeTranslationKey("recipe", "modifier.armor_trim.invalid_material");
    protected static final String KEY_INVALID_PATTERN = TConstruct.makeTranslationKey("recipe", "modifier.armor_trim.invalid_pattern");
    private final ResourceLocation id;
    private List<IDisplayModifierRecipe> displayRecipes = null;

    public ArmorTrimRecipe(ResourceLocation id) {
        this.id = id;
        ModifierRecipeLookup.addRecipeModifier(null, TinkerModifiers.trim);
    }

    @Nullable
    private static TrimItems findInputs(ITinkerStationContainer inv) {
        ItemStack template = ItemStack.f_41583_;
        ItemStack material = ItemStack.f_41583_;
        for (int i = 0; i < inv.getInputCount(); ++i) {
            ItemStack stack = inv.getInput(i);
            if (stack.m_41619_()) continue;
            if (stack.m_204117_(ItemTags.f_265940_)) {
                if (!template.m_41619_()) {
                    return null;
                }
                template = stack;
            }
            if (!stack.m_204117_(ItemTags.f_265843_)) continue;
            if (!material.m_41619_()) {
                return null;
            }
            material = stack;
        }
        if (!material.m_41619_() && !template.m_41619_()) {
            return new TrimItems(template, material);
        }
        return null;
    }

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        if (!inv.getTinkerableStack().m_204117_(TinkerTags.Items.TRIM)) {
            return false;
        }
        return ArmorTrimRecipe.findInputs(inv) != null;
    }

    @Override
    public RecipeResult<LazyToolStack> getValidatedResult(ITinkerStationContainer inv, RegistryAccess access) {
        TrimItems trimItems = ArmorTrimRecipe.findInputs(inv);
        if (trimItems == null) {
            return RecipeResult.pass();
        }
        Optional material = TrimMaterials.m_266539_((RegistryAccess)access, (ItemStack)trimItems.material);
        if (material.isEmpty()) {
            return RecipeResult.failure(KEY_INVALID_MATERIAL, trimItems.material.m_41611_());
        }
        Optional pattern = TrimPatterns.m_266468_((RegistryAccess)access, (ItemStack)trimItems.template);
        if (pattern.isEmpty()) {
            return RecipeResult.failure(KEY_INVALID_PATTERN, trimItems.template.m_41611_());
        }
        ToolStack tool = inv.getTinkerable().copy();
        ToolDataNBT persistentData = tool.getPersistentData();
        ModifierId modifier = TinkerModifiers.trim.getId();
        persistentData.putString(TrimModule.materialKey(modifier), ((Holder.Reference)material.get()).m_205785_().m_135782_().toString());
        persistentData.putString(TrimModule.patternKey(modifier), ((Holder.Reference)pattern.get()).m_205785_().m_135782_().toString());
        if (tool.getModifierLevel(modifier) == 0) {
            tool.addModifier(modifier, 1);
        }
        return ITinkerStationRecipe.success(tool, inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.armorTrimSerializer.get();
    }

    public List<IDisplayModifierRecipe> getRecipes(RegistryAccess access) {
        if (this.displayRecipes == null) {
            List<ItemStack> trims = RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_257033_, (TagKey)ItemTags.f_265940_).map(ItemStack::new).toList();
            List<ItemStack> toolInputs = RegistryHelper.getTagValueStream((Registry)BuiltInRegistries.f_257033_, TinkerTags.Items.TRIM).map(IModifiableDisplay::getDisplayStack).toList();
            ResourceLocation id = this.m_6423_();
            this.displayRecipes = access.m_175515_(Registries.f_266076_).m_203611_().map(material -> new DisplayRecipe(id, toolInputs, trims, (Holder.Reference<TrimMaterial>)material)).collect(Collectors.toList());
        }
        return this.displayRecipes;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    private record TrimItems(ItemStack template, ItemStack material) {
    }

    private static class DisplayRecipe
    implements IDisplayModifierRecipe {
        private static final IntRange LEVELS = new IntRange(1, 1);
        private final ModifierEntry RESULT = new ModifierEntry(TinkerModifiers.trim, 1);
        private final ResourceLocation recipeId;
        private final List<ItemStack> toolWithoutModifier;
        private final List<ItemStack> toolWithModifier;
        private final List<ItemStack> trim;
        private final List<ItemStack> material;
        private final Component variant;

        public DisplayRecipe(ResourceLocation id, List<ItemStack> tools, List<ItemStack> trim, Holder.Reference<TrimMaterial> holder) {
            this.recipeId = id;
            TrimMaterial material = (TrimMaterial)holder.get();
            this.toolWithoutModifier = tools;
            this.trim = trim;
            this.material = List.of(new ItemStack((ItemLike)material.f_265970_().get()));
            this.variant = material.f_266021_().m_6879_();
            String materialName = holder.m_205785_().m_135782_().toString();
            List<ModifierEntry> results = List.of(this.RESULT);
            ResourceLocation key = TrimModule.materialKey(TinkerModifiers.trim.getId());
            this.toolWithModifier = tools.stream().map(stack -> IDisplayModifierRecipe.withModifiers(stack, results, (ModDataNBT data) -> data.putString(key, materialName))).toList();
        }

        @Override
        public int getInputCount() {
            return 2;
        }

        @Override
        public List<ItemStack> getDisplayItems(int slot) {
            return switch (slot) {
                case 0 -> this.trim;
                case 1 -> this.material;
                default -> List.of();
            };
        }

        @Override
        public ModifierEntry getDisplayResult() {
            return this.RESULT;
        }

        @Override
        public IntRange getLevel() {
            return LEVELS;
        }

        @Override
        public ResourceLocation getRecipeId() {
            return this.recipeId;
        }

        @Override
        public List<ItemStack> getToolWithoutModifier() {
            return this.toolWithoutModifier;
        }

        @Override
        public List<ItemStack> getToolWithModifier() {
            return this.toolWithModifier;
        }

        @Override
        public Component getVariant() {
            return this.variant;
        }
    }
}

