/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.utils.Util;

public class NecroticModifier
extends Modifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook,
OnAttackedModifierHook,
TooltipModifierHook {
    private static final Component LIFE_STEAL = TConstruct.makeTranslation("modifier", "necrotic.lifesteal");

    @Override
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, ModifierHooks.PROJECTILE_HIT, ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.ON_ATTACKED, ModifierHooks.TOOLTIP);
    }

    @Override
    public void onMonsterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage) {
        float percent;
        if (damage > 0.0f && !context.getTarget().m_6095_().m_204039_(TinkerTags.EntityTypes.NECROTIC_BLACKLIST) && (percent = 0.05f * modifier.getEffectiveLevel()) > 0.0f) {
            LivingEntity attacker = context.getAttacker();
            attacker.m_5634_(percent * damage);
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
            ToolDamageUtil.damageAnimated(tool, modifier.getLevel(), attacker, context.getSlotType(), true);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged() && context.isCritical()) {
            this.onMonsterMeleeHit(tool, modifier, context, damageDealt);
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        float power;
        float percent;
        if (target != null && attacker != null && !target.m_6095_().m_204039_(TinkerTags.EntityTypes.NECROTIC_BLACKLIST) && (percent = 0.05f * modifier.getEffectiveLevel()) > 0.0f && (power = ProjectileWithPower.getDamage(projectile)) > 0.0f) {
            attacker.m_5634_(percent * Math.min(target.m_21223_(), power));
            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            int heal;
            LivingEntity defender = context.getEntity();
            if (RANDOM.nextFloat() < 0.15f && (heal = (int)(0.25f * modifier.getEffectiveLevel() * amount)) > 0) {
                defender.m_7292_(new MobEffectInstance(MobEffects.f_19605_, heal * 50));
                defender.m_9236_().m_6263_(null, defender.m_20185_(), defender.m_20186_(), defender.m_20189_(), Sounds.NECROTIC_HEAL.getSound(), SoundSource.PLAYERS, 1.0f, 1.0f);
                ToolDamageUtil.damageAnimated(tool, modifier.getLevel(), defender, slotType, true);
            }
        }
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float lifesteal = 0.05f * (float)modifier.getLevel();
        if (lifesteal > 0.0f) {
            tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.PERCENT_FORMAT.format(lifesteal) + " ")).m_7220_(LIFE_STEAL)));
        }
    }
}

