/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.data.material;

import net.minecraft.data.PackOutput;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.common.data.ExistingFileHelper;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialRenderInfoProvider;
import slimeknights.tconstruct.library.client.data.material.AbstractMaterialSpriteProvider;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.tools.data.material.MaterialIds;

public class MaterialRenderInfoProvider
extends AbstractMaterialRenderInfoProvider {
    public MaterialRenderInfoProvider(PackOutput packOutput, AbstractMaterialSpriteProvider spriteProvider, ExistingFileHelper existingFileHelper) {
        super(packOutput, spriteProvider, existingFileHelper);
    }

    @Override
    protected void addMaterialRenderInfo() {
        this.buildRenderInfo(IMaterial.UNKNOWN_ID);
        this.buildRenderInfo(MaterialIds.flint).color(0x3D3C3C).fallbacks("crystal", "rock", "stick");
        this.buildRenderInfo(MaterialIds.bone).color(15263186).fallbacks("bone", "rock");
        this.buildRenderInfo(MaterialIds.chorus);
        this.buildRenderInfo(MaterialIds.string).color(0xFFFFFF);
        this.buildRenderInfo(MaterialIds.leather).color(12999733);
        this.buildRenderInfo(MaterialIds.vine).color(4764952).fallbacks("vine");
        this.buildRenderInfo(MaterialIds.ice).color(7646206);
        this.buildRenderInfo(MaterialIds.cactus).color(6592562);
        this.buildRenderInfo(MaterialIds.paper);
        this.redirect(MaterialIds.leaves, MaterialIds.vine);
        this.buildRenderInfo(MaterialIds.wood).color(8873511).fallbacks("wood", "stick", "primitive");
        this.buildRenderInfo(MaterialIds.crimson);
        this.buildRenderInfo(MaterialIds.warped);
        this.buildRenderInfo(MaterialIds.bamboo);
        this.redirect(MaterialIds.rock, MaterialIds.stone);
        this.buildRenderInfo(MaterialIds.stone).color(11644845);
        this.buildRenderInfo(MaterialIds.diorite);
        this.buildRenderInfo(MaterialIds.granite);
        this.buildRenderInfo(MaterialIds.blackstone);
        this.buildRenderInfo(MaterialIds.basalt);
        this.redirect(MaterialIds.andesite, MaterialIds.stone);
        this.redirect(MaterialIds.calcite, MaterialIds.diorite);
        this.redirect(MaterialIds.deepslate, MaterialIds.basalt);
        MaterialVariantId whiteWool = MaterialVariantId.create(MaterialIds.wool, DyeColor.WHITE.m_41065_());
        this.redirect(MaterialIds.wool, whiteWool);
        for (DyeColor color : DyeColor.values()) {
            this.buildRenderInfo(MaterialVariantId.create(MaterialIds.wool, color.m_41065_()));
        }
        this.redirect(MaterialIds.feather, whiteWool);
        this.buildRenderInfo(MaterialIds.iron).color(0xD8D8D8).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.oxidizedIron).color(15321265).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.copper).color(15170646).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.oxidizedCopper).color(5221264).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.searedStone).color(5196359).fallbacks("rock");
        this.buildRenderInfo(MaterialIds.scorchedStone).color(5983299).fallbacks("rock");
        this.buildRenderInfo(MaterialIds.venombone).color(10654558).fallbacks("bone", "rock");
        this.buildRenderInfo(MaterialIds.necroticBone).color(0x2A2A2A).fallbacks("bone", "rock");
        this.buildRenderInfo(MaterialIds.endstone);
        this.redirect(MaterialIds.whitestone, MaterialIds.endstone);
        this.buildRenderInfo(MaterialIds.skyslimeVine).color(62682).fallbacks("vine");
        this.buildRenderInfo(MaterialIds.weepingVine);
        this.buildRenderInfo(MaterialIds.twistingVine);
        this.redirect(MaterialIds.slimewood, MaterialIds.greenheart);
        this.buildRenderInfo(MaterialIds.greenheart);
        this.buildRenderInfo(MaterialIds.skyroot);
        this.buildRenderInfo(MaterialIds.bloodshroom);
        this.buildRenderInfo(MaterialIds.enderbark);
        this.buildRenderInfo(MaterialIds.slimeskin);
        this.redirect(MaterialIds.slimeball, MaterialIds.earthslime);
        this.redirect(MaterialVariantId.create(MaterialIds.slimeball, "sky"), MaterialIds.skyslime);
        this.redirect(MaterialVariantId.create(MaterialIds.slimeball, "ichor"), MaterialIds.ichor);
        this.redirect(MaterialVariantId.create(MaterialIds.slimeball, "ender"), MaterialIds.enderslime);
        this.buildRenderInfo(MaterialIds.slimesteel).color(4648167).fallbacks("slime_metal", "metal");
        this.buildRenderInfo(MaterialIds.amethystBronze).color(14262992).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.nahuatl).color(3876692).fallbacks("wood", "stick");
        this.buildRenderInfo(MaterialIds.pigIron).color(15771812).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.roseGold).color(16240059).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.cobalt).color(2324189).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.steel).color(0x959595).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.darkthread);
        this.buildRenderInfo(MaterialIds.ichorskin);
        this.buildRenderInfo(MaterialIds.cinderslime).luminosity(SlimeType.ICHOR.getLightLevel());
        this.buildRenderInfo(MaterialIds.queensSlime).color(8427794).fallbacks("slime_metal", "metal").luminosity(9);
        this.buildRenderInfo(MaterialIds.hepatizon).color(6310251).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.manyullyn).color(9593292).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.knightmetal).color(12900014).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.knightslime);
        this.buildRenderInfo(MaterialIds.blazingBone).color(15914240).fallbacks("bone", "rock").luminosity(15);
        this.buildRenderInfo(MaterialIds.blazewood).fallbacks("wood", "stick").luminosity(7);
        this.buildRenderInfo(MaterialIds.ancientHide);
        this.buildRenderInfo(MaterialIds.ancient);
        this.buildRenderInfo(MaterialIds.enderslimeVine).color(11087359).fallbacks("vine");
        this.buildRenderInfo(MaterialIds.osmium).color(12707572).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.ironwood);
        this.buildRenderInfo(MaterialIds.silver).color(14349293).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.lead).color(6907257).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.whitestoneComposite, MaterialIds.whitestone).color(14739948).fallbacks("rock");
        this.buildRenderInfo(MaterialIds.treatedWood);
        this.redirect(MaterialIds.whitestoneAluminum, MaterialIds.whitestoneComposite);
        this.redirect(MaterialIds.whitestoneTin, MaterialIds.whitestoneComposite);
        this.redirect(MaterialIds.whitestoneZinc, MaterialIds.whitestoneComposite);
        this.buildRenderInfo(MaterialIds.aluminum);
        this.buildRenderInfo(MaterialIds.bronze).color(13932389).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.constantan).color(16747376).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.invar).color(13294544).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.pewter).color(10065027).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.necronium).color(10272137).fallbacks("bone", "metal");
        this.buildRenderInfo(MaterialIds.electrum).color(16771685).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.platedSlimewood).color(16769392).fallbacks("slime_metal", "metal");
        this.buildRenderInfo(MaterialIds.steeleaf);
        this.buildRenderInfo(MaterialIds.fiery).color(8994068).fallbacks("metal").luminosity(15);
        this.buildRenderInfo(MaterialIds.amethyst);
        this.buildRenderInfo(MaterialIds.prismarine);
        this.buildRenderInfo(MaterialIds.glass);
        this.buildRenderInfo(MaterialIds.earthslime);
        this.buildRenderInfo(MaterialIds.skyslime);
        this.buildRenderInfo(MaterialIds.enderslime);
        this.buildRenderInfo(MaterialIds.blaze);
        this.buildRenderInfo(MaterialIds.enderPearl);
        this.buildRenderInfo(MaterialIds.quartz);
        this.buildRenderInfo(MaterialIds.ichor).luminosity(10);
        this.buildRenderInfo(MaterialIds.magma).luminosity(5);
        this.buildRenderInfo(MaterialIds.glowstone).luminosity(15);
        this.buildRenderInfo(MaterialIds.gunpowder);
        this.buildRenderInfo(MaterialIds.redstone);
        this.buildRenderInfo(MaterialIds.dragonScale);
        this.buildRenderInfo(MaterialIds.endRod);
        this.redirect(MaterialIds.magnetite, MaterialIds.steel);
        this.redirect(MaterialIds.shulker, MaterialIds.chorus);
        this.redirect(MaterialIds.knightly, MaterialIds.knightmetal);
        this.buildRenderInfo(MaterialIds.gold).color(0xFDF55F).fallbacks("metal");
        this.buildRenderInfo(MaterialIds.obsidian);
        this.buildRenderInfo(MaterialIds.blood);
        this.buildRenderInfo(MaterialIds.clay);
        this.buildRenderInfo(MaterialIds.honey);
        this.buildRenderInfo(MaterialIds.phantom);
        this.redirect(ToolBuildHandler.getRenderMaterial(0), MaterialIds.iron);
        this.redirect(ToolBuildHandler.getRenderMaterial(1), MaterialIds.wood);
        this.redirect(ToolBuildHandler.getRenderMaterial(2), MaterialIds.cobalt);
        this.redirect(ToolBuildHandler.getRenderMaterial(3), MaterialIds.manyullyn);
        this.redirect(ToolBuildHandler.getRenderMaterial(4), MaterialIds.copper);
    }

    public String m_6055_() {
        return "Tinkers' Construct Material Render Info Provider";
    }
}

