/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.library.tools.part.ToolPartItem;
import slimeknights.tconstruct.library.tools.part.block.MaterialBlockItem;

public class AnvilBlockItem
extends MaterialBlockItem {
    private final Supplier<? extends IMaterialItem> matching;
    private final TagKey<IMaterial> validMaterials;

    public AnvilBlockItem(Block block, Item.Properties properties, Supplier<? extends IMaterialItem> matching, TagKey<IMaterial> validMaterials) {
        super(block, properties);
        this.matching = matching;
        this.validMaterials = validMaterials;
    }

    @Deprecated(forRemoval=true)
    public AnvilBlockItem(Block block, Item.Properties properties, Supplier<? extends IMaterialItem> matching) {
        this(block, properties, matching, TinkerTags.Materials.COMPATABILITY_ALLOYS);
    }

    @Override
    public boolean canUseMaterial(MaterialId material) {
        return MaterialRegistry.getInstance().isInTag(material, this.validMaterials) && this.matching.get().canUseMaterial(material);
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        return Component.m_237115_((String)this.m_5671_(stack));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        this.m_40614_().m_5871_(stack, (BlockGetter)level, tooltip, flag);
        MaterialVariantId material = this.getMaterial(stack);
        if (!IMaterial.UNKNOWN_ID.equals(material)) {
            tooltip.add((Component)this.matching.get().m_5456_().m_7626_(stack).m_6881_().m_130940_(ChatFormatting.GRAY));
            if (flag.m_7050_()) {
                tooltip.add((Component)Component.m_237110_((String)ToolPartItem.MATERIAL_KEY, (Object[])new Object[]{material}).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
    }

    @Override
    @Nullable
    public String getCreatorModId(ItemStack stack) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135827_();
    }

    @Override
    public void addVariants(Consumer<ItemStack> items, String showOnlyMaterial) {
        RetexturedHelper.addTagVariants(stack -> {
            items.accept((ItemStack)stack);
            return false;
        }, (ItemLike)this, TinkerTags.Items.ANVIL_METAL);
        super.addVariants(items, showOnlyMaterial);
    }
}

