/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.HarvestEnchantmentsModifierHook;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.aoe.AreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.library.utils.Util;

public class ToolHarvestLogic {
    private ToolHarvestLogic() {
    }

    public static int getDamage(ToolStack tool, Level world, BlockPos pos, BlockState state) {
        return ToolHarvestLogic.getDamage((IToolStackView)tool, world, pos, state);
    }

    public static int getDamage(IToolStackView tool, Level world, BlockPos pos, BlockState state) {
        if (state.m_60800_((BlockGetter)world, pos) == 0.0f || !tool.hasTag(TinkerTags.Items.HARVEST)) {
            return !state.m_204336_(BlockTags.f_13076_) && ModifierUtil.canPerformAction(tool, ToolActions.SHEARS_DIG) ? 1 : 0;
        }
        return tool.hasTag(TinkerTags.Items.HARVEST_PRIMARY) ? 1 : 2;
    }

    private static boolean removeBlock(IToolStackView tool, ToolHarvestContext context) {
        Boolean removed = null;
        if (!tool.isBroken()) {
            ModifierEntry entry;
            Iterator<ModifierEntry> iterator = tool.getModifierList().iterator();
            while (iterator.hasNext() && (removed = (entry = iterator.next()).getHook(ModifierHooks.REMOVE_BLOCK).removeBlock(tool, entry, context)) == null) {
            }
        }
        BlockState state = context.getState();
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        if (removed == null) {
            removed = state.onDestroyedByPlayer((Level)world, pos, (Player)context.getPlayer(), context.canHarvest(), world.m_6425_(pos));
        }
        if (removed.booleanValue()) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
        }
        return removed;
    }

    @Deprecated(forRemoval=true)
    protected static boolean breakBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        return ToolHarvestLogic.breakBlock(tool, stack, context, false);
    }

    @Deprecated(forRemoval=true)
    protected static boolean breakBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context, boolean useLastXP) {
        return ToolHarvestLogic.breakBlock((IToolStackView)tool, stack, context, useLastXP);
    }

    protected static boolean breakBlock(IToolStackView tool, ItemStack stack, ToolHarvestContext context, boolean useLastXP) {
        int exp;
        ServerPlayer player = Objects.requireNonNull(context.getPlayer());
        ServerLevel world = context.getWorld();
        BlockPos pos = context.getPos();
        GameType type = player.f_8941_.m_9290_();
        int n = exp = useLastXP ? BlockSideHitListener.getLastXP((Player)player) : ForgeHooks.onBlockBreakEvent((Level)world, (GameType)type, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        if (player.m_36187_((Level)world, pos, type)) {
            return false;
        }
        if (player.m_7500_()) {
            ToolHarvestLogic.removeBlock(tool, context);
            return true;
        }
        BlockState state = context.getState();
        int damage = ToolHarvestLogic.getDamage(tool, (Level)world, pos, state);
        boolean canHarvest = context.canHarvest();
        BlockEntity te = canHarvest ? world.m_7702_(pos) : null;
        boolean removed = ToolHarvestLogic.removeBlock(tool, context);
        Block block = state.m_60734_();
        if (removed && canHarvest) {
            block.m_6240_((Level)world, (Player)player, pos, state, te, stack);
        }
        if (removed && exp > 0) {
            block.m_49805_(world, pos, exp);
        }
        if (removed && !tool.isBroken()) {
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.BLOCK_BREAK).afterBlockBreak(tool, entry, context);
            }
            ToolDamageUtil.damageAnimated(tool, damage, (LivingEntity)player);
        }
        return removed;
    }

    public static boolean breakExtraBlock(ToolStack tool, ItemStack stack, ToolHarvestContext context) {
        return ToolHarvestLogic.breakExtraBlock((IToolStackView)tool, stack, context);
    }

    public static boolean breakExtraBlock(IToolStackView tool, ItemStack stack, ToolHarvestContext context) {
        if (ToolHarvestLogic.breakBlock(tool, stack, context, false)) {
            ServerLevel world = context.getWorld();
            BlockPos pos = context.getPos();
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)context.getState()));
            TinkerNetwork.getInstance().sendVanillaPacket((Entity)Objects.requireNonNull(context.getPlayer()), (Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
            return true;
        }
        return false;
    }

    public static boolean handleBlockBreak(ItemStack stack, BlockPos pos, Player player) {
        if (player.m_9236_().f_46443_ || !(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ToolStack tool = ToolStack.from(stack);
        Direction sideHit = BlockSideHitListener.getSideHit(player);
        ServerLevel world = serverPlayer.m_284548_();
        BlockState state = world.m_8055_(pos);
        if (tool.isBroken()) {
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            ToolHarvestContext context = new ToolHarvestContext(world, serverPlayer, state, pos, sideHit, !player.m_7500_() && state.canHarvestBlock((BlockGetter)world, pos, player), false);
            ToolHarvestLogic.breakBlock(tool, ItemStack.f_41583_, context, true);
            player.m_21008_(InteractionHand.MAIN_HAND, stack);
        } else {
            ToolHarvestLogic.runBlockBreak(stack, tool, state, pos, sideHit, serverPlayer, null);
        }
        return true;
    }

    public static int runBlockBreak(ItemStack stack, IToolStackView tool, BlockState state, BlockPos pos, Direction sideHit, ServerPlayer player, @Nullable Projectile projectile) {
        ServerLevel world = player.m_284548_();
        ToolHarvestContext context = new ToolHarvestContext(world, player, projectile, state, pos, sideHit, !player.m_7500_() && state.canHarvestBlock((BlockGetter)world, pos, (Player)player), IsEffectiveToolHook.isEffective(tool, state));
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(ModifierHooks.BLOCK_HARVEST).startHarvest(tool, entry, context);
        }
        ListTag originalEnchantments = HarvestEnchantmentsModifierHook.updateHarvestEnchantments(tool, stack, context);
        UseOnContext useContext = new UseOnContext((Level)world, (Player)player, InteractionHand.MAIN_HAND, stack, Util.createTraceResult(pos, sideHit, false));
        List<BlockPos> extraBlocks = context.isEffective() ? tool.getHook(ToolHooks.AOE_ITERATOR).getBlocks(tool, useContext, state, AreaOfEffectIterator.AOEMatchType.BREAKING) : Collections.emptyList();
        int harvested = 0;
        if (ToolHarvestLogic.breakBlock(tool, stack, context, true)) {
            ++harvested;
            for (BlockPos extraPos : extraBlocks) {
                BlockState extraState = world.m_8055_(extraPos);
                if (extraState.m_60795_() || !ToolHarvestLogic.breakExtraBlock(tool, stack, context.forPosition(extraPos.m_7949_(), extraState))) continue;
                ++harvested;
            }
        }
        if (originalEnchantments != null) {
            HarvestEnchantmentsModifierHook.restoreEnchantments(stack, originalEnchantments);
        }
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(ModifierHooks.BLOCK_HARVEST).finishHarvest(tool, entry, context, harvested);
        }
        return harvested;
    }

    public static boolean mineBlock(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!stack.m_204117_(TinkerTags.Items.HARVEST)) {
            return false;
        }
        ToolStack tool = ToolStack.from(stack);
        if (tool.isBroken()) {
            return false;
        }
        if (!worldIn.f_46443_ && worldIn instanceof ServerLevel) {
            boolean isEffective = IsEffectiveToolHook.isEffective(tool, state);
            ToolHarvestContext context = new ToolHarvestContext((ServerLevel)worldIn, entityLiving, state, pos, Direction.UP, true, isEffective);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(ModifierHooks.BLOCK_BREAK).afterBlockBreak(tool, entry, context);
            }
            ToolDamageUtil.damageAnimated(tool, ToolHarvestLogic.getDamage(tool, worldIn, pos, state), entityLiving);
        }
        return true;
    }
}

