/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.json.predicate.material.MaterialPredicate;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.casting.material.AbstractMaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.ToolCastingRecipe;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialCastingRecipeBuilder
extends AbstractRecipeBuilder<MaterialCastingRecipeBuilder> {
    @Nullable
    private final IMaterialItem result;
    @Nullable
    private final IModifiable resultTool;
    private final TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe> recipeSerializer;
    private Ingredient cast = Ingredient.f_43901_;
    private int itemCost = 0;
    private ToolCastingRecipe.CastPurpose castPurpose = ToolCastingRecipe.CastPurpose.CATALYST;
    private boolean switchSlots = false;
    private IJsonPredicate<MaterialVariantId> allowedMaterials = MaterialPredicate.ANY;
    private final List<MaterialVariantId> extraMaterials = new ArrayList<MaterialVariantId>();

    public static MaterialCastingRecipeBuilder basinRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, null, (TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinMaterialSerializer.get()));
    }

    public static MaterialCastingRecipeBuilder tableRecipe(IMaterialItem result) {
        return MaterialCastingRecipeBuilder.castingRecipe(result, null, (TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tableMaterialSerializer.get()));
    }

    public static MaterialCastingRecipeBuilder basinRecipe(IModifiable result) {
        return MaterialCastingRecipeBuilder.castingRecipe(null, result, (TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.basinToolSerializer.get()));
    }

    public static MaterialCastingRecipeBuilder tableRecipe(IModifiable result) {
        return MaterialCastingRecipeBuilder.castingRecipe(null, result, (TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe>)((TypeAwareRecipeSerializer)TinkerSmeltery.tableToolSerializer.get()));
    }

    public MaterialCastingRecipeBuilder setCast(Ingredient cast, ToolCastingRecipe.CastPurpose purpose) {
        this.cast = cast;
        this.castPurpose = purpose;
        return this;
    }

    public MaterialCastingRecipeBuilder setCast(Ingredient cast, boolean consumed) {
        return this.setCast(cast, consumed ? ToolCastingRecipe.CastPurpose.MAYBE_MATERIAL : ToolCastingRecipe.CastPurpose.CATALYST);
    }

    public MaterialCastingRecipeBuilder setCast(ItemLike item, ToolCastingRecipe.CastPurpose purpose) {
        return this.setCast(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), purpose);
    }

    public MaterialCastingRecipeBuilder setCast(ItemLike item, boolean consumed) {
        return this.setCast(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), consumed);
    }

    public MaterialCastingRecipeBuilder setCast(TagKey<Item> tag, boolean consumed) {
        return this.setCast(Ingredient.m_204132_(tag), consumed);
    }

    public MaterialCastingRecipeBuilder setSwitchSlots() {
        this.switchSlots = true;
        return this;
    }

    public MaterialCastingRecipeBuilder addExtraMaterial(MaterialVariantId material) {
        this.extraMaterials.add(material);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, BuiltInRegistries.f_257033_.m_7981_((Object)Objects.requireNonNull(this.result).m_5456_()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.itemCost <= 0) {
            throw new IllegalStateException("Material casting recipes require a positive amount of fluid");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "casting");
        if (this.result != null) {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MaterialCastingRecipe(this.recipeSerializer, id, this.group, this.cast, this.itemCost, this.result, this.allowedMaterials, this.castPurpose != ToolCastingRecipe.CastPurpose.CATALYST, this.switchSlots), MaterialCastingRecipe.LOADER, advancementId));
        } else if (this.resultTool != null) {
            consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new ToolCastingRecipe(this.recipeSerializer, id, this.group, this.cast, this.itemCost, this.castPurpose, this.resultTool, this.allowedMaterials, this.extraMaterials), ToolCastingRecipe.LOADER, advancementId));
        } else {
            throw new IllegalArgumentException("Must have either result or result tool");
        }
    }

    private MaterialCastingRecipeBuilder(@Nullable IMaterialItem result, @Nullable IModifiable resultTool, TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe> recipeSerializer) {
        this.result = result;
        this.resultTool = resultTool;
        this.recipeSerializer = recipeSerializer;
    }

    public static MaterialCastingRecipeBuilder castingRecipe(@Nullable IMaterialItem result, @Nullable IModifiable resultTool, TypeAwareRecipeSerializer<? extends AbstractMaterialCastingRecipe> recipeSerializer) {
        return new MaterialCastingRecipeBuilder(result, resultTool, recipeSerializer);
    }

    public MaterialCastingRecipeBuilder setItemCost(int itemCost) {
        this.itemCost = itemCost;
        return this;
    }

    public MaterialCastingRecipeBuilder setAllowedMaterials(IJsonPredicate<MaterialVariantId> allowedMaterials) {
        this.allowedMaterials = allowedMaterials;
        return this;
    }
}

