/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor.texture;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import slimeknights.mantle.data.loadable.common.ColorLoadable;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.TintedArmorTexture;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modules.cosmetic.TrimModule;

public record TrimArmorTextureSupplier(ModifierId modifier, ResourceLocation patternKey, ResourceLocation materialKey) implements ArmorTextureSupplier
{
    public static TrimArmorTextureSupplier INSTANCE = new TrimArmorTextureSupplier(TinkerModifiers.trim.getId());
    public static final RecordLoadable<TrimArmorTextureSupplier> LOADER = RecordLoadable.create((RecordField)ModifierId.PARSER.defaultField("modifier", (Object)TinkerModifiers.trim.getId(), TrimArmorTextureSupplier::modifier), TrimArmorTextureSupplier::new);
    private static final Map<String, ArmorTextureSupplier.ArmorTexture> ARMOR_CACHE = new HashMap<String, ArmorTextureSupplier.ArmorTexture>();
    private static final Map<String, ArmorTextureSupplier.ArmorTexture> LEGGING_CACHE = new HashMap<String, ArmorTextureSupplier.ArmorTexture>();
    public static final ResourceManagerReloadListener CACHE_INVALIDATOR = manager -> {
        ARMOR_CACHE.clear();
        LEGGING_CACHE.clear();
        TrimArmorTexture.armorTrimAtlas = null;
    };

    public TrimArmorTextureSupplier(ModifierId modifier) {
        this(modifier, TrimModule.patternKey(modifier), TrimModule.materialKey(modifier));
    }

    @Override
    public ArmorTextureSupplier.ArmorTexture getArmorTexture(ItemStack stack, ArmorTextureSupplier.TextureType textureType, RegistryAccess access) {
        if (textureType != ArmorTextureSupplier.TextureType.WINGS) {
            String patternId = ModifierUtil.getPersistentString(stack, this.patternKey);
            String materialId = ModifierUtil.getPersistentString(stack, this.materialKey);
            if (!patternId.isEmpty() && !materialId.isEmpty()) {
                String key;
                Map<String, ArmorTextureSupplier.ArmorTexture> cache = textureType == ArmorTextureSupplier.TextureType.LEGGINGS ? LEGGING_CACHE : ARMOR_CACHE;
                ArmorTextureSupplier.ArmorTexture texture = cache.get(key = patternId + "#" + materialId);
                if (texture != null) {
                    return texture;
                }
                TrimPattern pattern = (TrimPattern)access.m_175515_(Registries.f_266063_).m_7745_(ResourceLocation.m_135820_((String)patternId));
                TrimMaterial material = (TrimMaterial)access.m_175515_(Registries.f_266076_).m_7745_(ResourceLocation.m_135820_((String)materialId));
                texture = ArmorTextureSupplier.ArmorTexture.EMPTY;
                if (pattern != null && material != null) {
                    ResourceLocation patternAsset = pattern.f_266052_();
                    texture = TrimArmorTexture.create(patternAsset.m_247449_("trims/models/armor/" + patternAsset.m_135815_() + (textureType == ArmorTextureSupplier.TextureType.LEGGINGS ? "_leggings" : "")), material);
                }
                cache.put(key, texture);
                return texture;
            }
        }
        return ArmorTextureSupplier.ArmorTexture.EMPTY;
    }

    public RecordLoadable<TrimArmorTextureSupplier> getLoader() {
        return LOADER;
    }

    public static class TrimArmorTexture
    implements ArmorTextureSupplier.ArmorTexture {
        private static TextureAtlas armorTrimAtlas = null;
        private final TextureAtlasSprite trimSprite;

        private static TextureAtlas getTrimAtlas() {
            if (armorTrimAtlas == null) {
                armorTrimAtlas = Minecraft.m_91087_().m_91304_().m_119428_(Sheets.f_265912_);
            }
            return armorTrimAtlas;
        }

        private static ArmorTextureSupplier.ArmorTexture create(ResourceLocation root, TrimMaterial material) {
            ResourceLocation withMaterial = root.m_266382_("_" + material.f_265854_());
            TextureAtlasSprite sprite = TrimArmorTexture.getTrimAtlas().m_118316_(withMaterial);
            if (!MissingTextureAtlasSprite.m_118071_().equals((Object)sprite.m_245424_().m_246162_())) {
                return new TrimArmorTexture(sprite);
            }
            int color = -1;
            TextColor textColor = material.f_266021_().m_7383_().m_131135_();
            if (textColor != null) {
                color = textColor.m_131265_() | 0xFF000000;
            }
            TConstruct.LOG.error("Missing material specific texture {}, defaulting to tinting base texture #{}", (Object)withMaterial, (Object)ColorLoadable.NO_ALPHA.getString((Object)color));
            return new TintedArmorTexture(root.m_247449_("textures/" + root.m_135815_() + ".png"), color);
        }

        @Override
        public void renderTexture(Model model, PoseStack matrices, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, boolean hasGlint) {
            VertexConsumer buffer = this.trimSprite.m_118381_(bufferSource.m_6299_(Sheets.m_266442_()));
            model.m_7695_(matrices, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        }

        public TrimArmorTexture(TextureAtlasSprite trimSprite) {
            this.trimSprite = trimSprite;
        }
    }
}

