/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.item.ItemPredicate;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.entity.ProjectileWithPower;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MonsterMeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BlockHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.LauncherHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.PlantHarvestModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.ShearsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.recipe.SingleItemContainer;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.inventory.InventoryModule;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.layout.Patterns;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record SmeltingModule(RecipeType<? extends AbstractCookingRecipe> recipeType, float multiplier, InventoryModule input, InventoryModule output) implements ModifierModule,
MeleeHitModifierHook,
MonsterMeleeHitModifierHook.RedirectAfter,
LauncherHitModifierHook,
BlockHarvestModifierHook,
ProjectileLaunchModifierHook,
OnAttackedModifierHook,
PlantHarvestModifierHook,
ShearsModifierHook,
SlingLaunchModifierHook
{
    private static final String TAG_TIME = "tic_remaining_time";
    private static final SingleItemContainer CONTAINER = new SingleItemContainer();
    private static AbstractCookingRecipe lastRecipe = null;
    private static final int NO_RECIPE = -1;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.MELEE_HIT, ModifierHooks.MONSTER_MELEE_HIT, ModifierHooks.LAUNCHER_HIT, ModifierHooks.BLOCK_HARVEST, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.ON_ATTACKED, ModifierHooks.PLANT_HARVEST, ModifierHooks.SHEAR_ENTITY, ModifierHooks.SLING_LAUNCH);
    public static final RecordLoadable<SmeltingModule> LOADER = RecordLoadable.create((RecordField)TinkerLoadables.RECIPE_TYPE.flatXmap(t -> t, t -> t).requiredField("recipe_type", SmeltingModule::recipeType), (RecordField)FloatLoadable.FROM_ZERO.requiredField("multiplier", SmeltingModule::multiplier), (RecordField)InventoryModule.LOADER.directField(SmeltingModule::input), (RecordField)OutputKeyField.INSTANCE, (RecordField)Pattern.PARSER.defaultField("output_pattern", (Object)Patterns.RESULT, true, m -> m.output.pattern()), SmeltingModule::new);

    public SmeltingModule(RecipeType<? extends AbstractCookingRecipe> recipeType, float multiplier, InventoryModule inventory, @Nullable ResourceLocation outputKey, Pattern outputPattern) {
        this(recipeType, multiplier, inventory, InventoryModule.builder().from(inventory).key(outputKey).pattern(outputPattern).filter((IJsonPredicate<Item>)ItemPredicate.NONE).slots(inventory.slots()));
    }

    public SmeltingModule(RecipeType<? extends AbstractCookingRecipe> recipeType, float multiplier, InventoryModule inventory) {
        this(recipeType, multiplier, inventory, null, Patterns.RESULT);
    }

    public RecordLoadable<SmeltingModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void addModules(ModuleHookMap.Builder builder) {
        builder.addModule(this.input);
        builder.addModule(this.output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static AbstractCookingRecipe findRecipe(RecipeType<? extends AbstractCookingRecipe> recipeType, ItemStack stack, Level level, ModifierId modifier) {
        CONTAINER.setStack(stack);
        try {
            if (lastRecipe != null && lastRecipe.m_5818_((Container)CONTAINER, level)) {
                AbstractCookingRecipe abstractCookingRecipe = lastRecipe;
                return abstractCookingRecipe;
            }
            AbstractCookingRecipe recipe = level.m_7465_().m_44015_(recipeType, (Container)CONTAINER, level).orElse(null);
            if (recipe != null) {
                lastRecipe = recipe;
            }
            AbstractCookingRecipe abstractCookingRecipe = recipe;
            return abstractCookingRecipe;
        }
        catch (Exception e) {
            TConstruct.LOG.error("Error fetching recipe for {} on modifier {}, this usually indicates a broken modifier or a broken recipe", (Object)stack, (Object)modifier, (Object)e);
            AbstractCookingRecipe abstractCookingRecipe = null;
            return abstractCookingRecipe;
        }
        finally {
            CONTAINER.setStack(ItemStack.f_41583_);
        }
    }

    private void cookItems(IToolStackView tool, ModifierEntry modifier, LivingEntity holder, float amount) {
        this.cookItems(tool, modifier, holder.m_9236_(), holder, amount);
    }

    private void cookItems(IToolStackView tool, ModifierEntry modifier, Level level, @Nullable LivingEntity holder, float amount) {
        ResourceLocation key;
        if (!this.input.condition().matches(tool, modifier) || amount < 0.0f) {
            return;
        }
        ModDataNBT data = tool.getPersistentData();
        if (data.contains(key = this.input.getKey(modifier.getModifier()), 9)) {
            ListTag list = tool.getPersistentData().get(key, InventoryModule.GET_COMPOUND_LIST);
            float cookingPower = amount * this.multiplier;
            for (int i = 0; i < list.size(); ++i) {
                AbstractCookingRecipe recipe = null;
                ItemStack stack = null;
                CompoundTag entry = list.m_128728_(i);
                int time = entry.m_128451_(TAG_TIME);
                if (time == 0) {
                    time = -1;
                    stack = ItemStack.m_41712_((CompoundTag)entry);
                    recipe = SmeltingModule.findRecipe(this.recipeType, stack, level, modifier.getId());
                    if (recipe != null) {
                        time = recipe.m_43753_();
                    }
                    entry.m_128405_(TAG_TIME, time);
                }
                if (time < 0) continue;
                if ((float)time > cookingPower) {
                    time = (int)((float)time - cookingPower);
                    entry.m_128405_(TAG_TIME, time);
                    continue;
                }
                int slot = entry.m_128451_("Slot");
                ItemStack currentResult = this.output.getStack(tool, modifier, slot);
                int maxStackSize = 0;
                if (!currentResult.m_41619_()) {
                    maxStackSize = Math.min(currentResult.m_41741_(), this.output.getSlotLimit(tool, modifier, slot));
                    if (currentResult.m_41613_() >= maxStackSize) {
                        entry.m_128405_(TAG_TIME, 1);
                        continue;
                    }
                }
                if (recipe == null && !(stack = ItemStack.m_41712_((CompoundTag)entry)).m_41619_()) {
                    recipe = SmeltingModule.findRecipe(this.recipeType, stack, level, modifier.getId());
                }
                if (recipe != null) {
                    CONTAINER.setStack(stack);
                    try {
                        ItemStack result = recipe.m_5874_((Container)CONTAINER, level.m_9598_());
                        if (!result.m_41619_()) {
                            if (maxStackSize == 0) {
                                maxStackSize = Math.min(result.m_41741_(), this.output.getSlotLimit(tool, modifier, slot));
                            }
                            if (result.m_41613_() + currentResult.m_41613_() > maxStackSize || !currentResult.m_41619_() && !ItemStack.m_150942_((ItemStack)currentResult, (ItemStack)result)) {
                                entry.m_128405_(TAG_TIME, 1);
                                CONTAINER.setStack(ItemStack.f_41583_);
                                continue;
                            }
                        }
                        if (currentResult.m_41619_()) {
                            this.output.setStack(tool, modifier, slot, result);
                        } else {
                            currentResult.m_41769_(result.m_41613_());
                            this.output.setStack(tool, modifier, slot, currentResult);
                        }
                        stack.m_41774_(1);
                        if (stack.m_41619_()) {
                            list.remove(i);
                            --i;
                        } else {
                            InventoryModule.writeStack(stack, slot, entry);
                            entry.m_128405_(TAG_TIME, recipe.m_43753_());
                        }
                        if (holder != null) {
                            level.m_6263_(null, holder.m_20185_(), holder.m_20186_(), holder.m_20189_(), SoundEvents.f_11914_, holder.m_5720_(), 1.0f, 1.0f);
                            float experience = recipe.m_43750_();
                            if (experience > 0.0f && level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                int floored = Mth.m_14143_((float)experience);
                                float fraction = Mth.m_14187_((float)experience);
                                if (fraction != 0.0f && level.m_213780_().m_188501_() < fraction) {
                                    ++floored;
                                }
                                ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)holder.m_20182_(), (int)floored);
                            }
                        }
                    }
                    catch (Exception e) {
                        TConstruct.LOG.error("Error getting result of recipe {} on modifier {}, this usually indicates a broken recipe", (Object)recipe.m_6423_(), (Object)modifier, (Object)e);
                    }
                    CONTAINER.setStack(ItemStack.f_41583_);
                    continue;
                }
                entry.m_128405_(TAG_TIME, -1);
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.cookItems(tool, modifier, context.getAttacker(), damageDealt);
    }

    @Override
    public void onLauncherHitEntity(IToolStackView tool, ModifierEntry modifier, Projectile projectile, LivingEntity attacker, Entity target, @Nullable LivingEntity livingTarget, float damageDealt) {
        this.cookItems(tool, modifier, attacker, damageDealt);
    }

    @Override
    public void finishHarvest(IToolStackView tool, ModifierEntry modifier, ToolHarvestContext context, int harvested) {
        if (tool.hasTag(TinkerTags.Items.HARVEST)) {
            this.cookItems(tool, modifier, context.getLiving(), harvested);
        }
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        float amount;
        if (arrow != null) {
            amount = (float)arrow.m_36789_();
        } else if (projectile instanceof ProjectileWithPower) {
            ProjectileWithPower withPower = (ProjectileWithPower)projectile;
            amount = withPower.getPower();
        } else {
            amount = ToolStats.PROJECTILE_DAMAGE.getDefaultValue().floatValue();
        }
        this.cookItems(tool, modifier, shooter, amount);
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            this.cookItems(tool, modifier, context.getEntity(), amount);
        }
    }

    @Override
    public void afterSlingLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity holder, LivingEntity target, ModifierEntry slingSource, float force, float multiplier, Vec3 angle) {
        this.cookItems(tool, modifier, holder, force * 2.0f / multiplier);
    }

    @Override
    public void afterHarvest(IToolStackView tool, ModifierEntry modifier, UseOnContext context, ServerLevel world, BlockState state, BlockPos pos) {
        this.cookItems(tool, modifier, context.m_43725_(), (LivingEntity)context.m_43723_(), 1.0f);
    }

    @Override
    public void afterShearEntity(IToolStackView tool, ModifierEntry modifier, Player player, Entity entity, boolean isTarget) {
        this.cookItems(tool, modifier, (LivingEntity)player, 1.0f);
    }

    private static enum OutputKeyField implements LoadableField<ResourceLocation, SmeltingModule>
    {
        INSTANCE;


        public String key() {
            return "output_key";
        }

        public ResourceLocation get(JsonObject json, String key, TypedMap context) {
            if (json.has(key)) {
                return JsonHelper.getResourceLocation((JsonObject)json, (String)key);
            }
            ResourceLocation id = (ResourceLocation)context.get((TypedMap.Key)ContextKey.ID);
            if (id != null) {
                return id.m_266382_("_output");
            }
            throw new JsonParseException("Unable to fetch ID from context, this usually implements a broken JSON deserializer");
        }

        public void serialize(SmeltingModule module, JsonObject json) {
            ResourceLocation key = module.output.key();
            if (key != null) {
                json.addProperty(this.key(), key.toString());
            }
        }

        public ResourceLocation decode(FriendlyByteBuf buffer, TypedMap context) {
            return buffer.m_130281_();
        }

        public void encode(FriendlyByteBuf buffer, SmeltingModule module) {
            buffer.m_130085_(Objects.requireNonNull(module.output.key()));
        }
    }
}

