/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedContext;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ScheduledProjectileTaskModifierHook;
import slimeknights.tconstruct.library.tools.IndestructibleItemEntity;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.ToolHooks;
import slimeknights.tconstruct.library.tools.definition.module.display.ToolNameHook;
import slimeknights.tconstruct.library.tools.definition.module.mining.IsEffectiveToolHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.helper.ToolHarvestLogic;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Schedule;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;
import slimeknights.tconstruct.tools.entity.ToolProjectile;
import slimeknights.tconstruct.tools.modifiers.upgrades.general.MagneticModifier;

public class ThrownTool
extends ThrownTrident
implements ToolProjectile {
    protected static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(ThrownTool.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Float> WATER_INERTIA = SynchedEntityData.m_135353_(ThrownTool.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final ResourceLocation LOYALTY = TConstruct.getResource("loyalty");
    @Nullable
    private IToolStackView tool = null;
    private float charge = 1.0f;
    private float multiplier = 1.0f;
    private boolean noDespawn = false;
    private int magnet = 0;
    private int originalSlot = -1;
    private boolean hitBlock = false;
    private Schedule tasks = Schedule.EMPTY;
    private static final String KEY_CHARGE = "charge";
    private static final String KEY_MULTIPLIER = "multiplier";
    private static final String KEY_WATER_INERTIA = "water_inertia";
    private static final String KEY_ORIGINAL_SLOT = "original_slot";
    private static final String KEY_HIT_BLOCK = "hit_block";
    private static final String KEY_TASKS = "tasks";

    public ThrownTool(EntityType<? extends ThrownTrident> type, Level level) {
        super(type, level);
    }

    public ThrownTool(Level level, LivingEntity shooter, ItemStack stack, float charge, float multiplier, float waterInertia) {
        this((EntityType<? extends ThrownTrident>)((EntityType)TinkerTools.thrownTool.get()), level);
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - 0.1, shooter.m_20189_());
        this.m_5602_((Entity)shooter);
        if (shooter instanceof Player) {
            this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        }
        this.f_37555_ = stack.m_255036_(1);
        this.charge = charge;
        this.multiplier = multiplier;
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(waterInertia));
        this.updateFromStack();
    }

    private void updateFromStack() {
        this.f_19804_.m_135381_(STACK, (Object)this.f_37555_);
        this.f_19804_.m_135381_(f_37558_, (Object)((byte)ModifierUtil.getVolatileInt(this.f_37555_, LOYALTY)));
        this.f_19804_.m_135381_(f_37554_, (Object)ModifierUtil.checkVolatileFlag(this.f_37555_, ModifiableItem.SHINY));
        this.noDespawn = ModifierUtil.checkVolatileFlag(this.f_37555_, IndestructibleItemEntity.INDESTRUCTIBLE_ENTITY);
        if (!this.m_9236_().f_46443_) {
            this.magnet = ModifierUtil.getModifierLevel(this.f_37555_, TinkerModifiers.magnetic.getId());
        }
    }

    public void onRelease(LivingEntity entity, ModDataNBT arrowData) {
        IToolStackView tool = this.getTool();
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(ModifierHooks.PROJECTILE_THROWN).onProjectileShoot(tool, entry, entity, this.f_37555_, (Projectile)this, null, arrowData, true);
        }
        this.tasks = ScheduledProjectileTaskModifierHook.createSchedule(tool, this.f_37555_, (Projectile)this, null, arrowData);
    }

    protected float m_6882_() {
        return ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue();
    }

    public boolean m_150194_() {
        return !this.f_37555_.m_41619_() && this.getTool().getModifiers().getLevel(ModifierIds.channeling) > 0;
    }

    public Component m_5446_() {
        if (this.f_37555_.m_41619_()) {
            return super.m_5446_();
        }
        IToolStackView tool = this.getTool();
        return ToolNameHook.getName(tool.getDefinition(), this.f_37555_, tool);
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || this.f_37555_.m_41619_()) {
            ++this.f_36697_;
            if (this.f_36697_ >= 1200) {
                this.m_146870_();
            }
        } else if (!this.noDespawn && (Byte)this.f_19804_.m_135370_(f_37558_) == 0) {
            ++this.f_36697_;
            if (this.f_36697_ >= 6000) {
                this.m_146870_();
            }
        }
    }

    protected void m_6088_() {
        if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED && (Byte)this.f_19804_.m_135370_(f_37558_) != 0) {
            this.f_37556_ = true;
            if (!this.f_37555_.m_41619_()) {
                LivingEntity l;
                Entity entity;
                ToolDamageUtil.damage(this.getTool(), 1, (entity = this.m_19749_()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null, this.f_37555_);
            }
        } else {
            super.m_6088_();
        }
    }

    private IToolStackView getTool() {
        if (this.tool == null) {
            this.tool = ToolStack.from(this.f_37555_);
        }
        return this.tool;
    }

    public void m_8119_() {
        if (!this.f_37556_ && this.f_36704_ > 4) {
            if (!this.f_37555_.m_41619_() && !this.m_9236_().f_46443_) {
                LivingEntity l;
                Entity entity;
                ToolDamageUtil.damage(this.getTool(), 1, (entity = this.m_19749_()) instanceof LivingEntity ? (l = (LivingEntity)entity) : null, this.f_37555_);
                this.f_19804_.m_276349_(STACK, (Object)this.f_37555_, true);
            }
            this.f_37556_ = true;
        }
        super.m_8119_();
        if (this.magnet > 0) {
            MagneticModifier.applyVelocity(this.m_9236_(), this.m_20182_(), this.magnet - 1, ItemEntity.class, 3, 0.05f, 32);
        }
        if (!this.tasks.isEmpty() && !this.f_37555_.m_41619_()) {
            ScheduledProjectileTaskModifierHook.checkSchedule(this.getTool(), this.f_37555_, (Projectile)this, null, this.tasks);
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity entity;
        this.f_37556_ = true;
        if (!this.f_37555_.m_41619_() && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            Entity target = pResult.m_82443_();
            IToolStackView tool = this.getTool();
            if (ToolAttackUtil.canPerformAttack(tool) && ToolAttackUtil.isAttackable(owner, target)) {
                boolean notSelf;
                ItemStack offhand = owner.m_21206_();
                boolean bl = notSelf = owner != target;
                if (notSelf) {
                    owner.m_21008_(InteractionHand.OFF_HAND, this.f_37555_);
                }
                if (ToolAttackUtil.performAttack(tool, ToolAttackContext.attacker(owner).target(target).hand(InteractionHand.OFF_HAND).baseDamage(tool.getStats().get(ToolStats.ATTACK_DAMAGE).floatValue() * this.multiplier).cooldown(this.charge).projectile((Projectile)this).build())) {
                    if (target.m_6095_() == EntityType.f_20566_ && tool.getModifiers().getLevel(TinkerModifiers.enderference.getId()) == 0) {
                        if (notSelf) {
                            owner.m_21008_(InteractionHand.OFF_HAND, offhand);
                        }
                        return;
                    }
                    if (target instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)target;
                        this.m_7761_(living);
                    }
                }
                if (notSelf) {
                    owner.m_21008_(InteractionHand.OFF_HAND, offhand);
                }
            }
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
            if (!this.m_9236_().f_46443_) {
                if (tool.getModifiers().getLevel(ModifierIds.channeling) == 0) {
                    this.m_5496_(tool.isBroken() ? SoundEvents.f_12018_ : SoundEvents.f_12514_, 1.0f, 1.0f);
                }
                this.f_19804_.m_276349_(STACK, (Object)this.f_37555_, true);
            }
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.hitBlock) {
            Entity entity;
            this.hitBlock = true;
            if (!this.f_37556_ && !this.f_37555_.m_41619_() && this.f_37555_.m_204117_(TinkerTags.Items.HARVEST) && (entity = this.m_19749_()) instanceof ServerPlayer) {
                ServerPlayer owner = (ServerPlayer)entity;
                IToolStackView tool = this.getTool();
                if (!tool.isBroken()) {
                    BlockPos pos = result.m_82425_();
                    Level level = this.m_9236_();
                    BlockState state = level.m_8055_(pos);
                    float hardness = state.m_60800_((BlockGetter)level, pos);
                    if (hardness != -1.0f && IsEffectiveToolHook.isEffective(tool, state)) {
                        float miningSpeed = 1.0f;
                        if (hardness > 0.0f) {
                            miningSpeed = Math.max(1.0f, tool.getHook(ToolHooks.MINING_SPEED).modifyDestroySpeed(tool, state, tool.getStats().get(ToolStats.MINING_SPEED).floatValue()));
                            float multiplier = this.charge * this.multiplier;
                            if (this.m_20069_() && this.m_6882_() < 0.9f) {
                                multiplier /= 5.0f;
                            }
                            miningSpeed *= multiplier;
                            ModifierNBT modifiers = tool.getModifiers();
                            Direction sideHit = result.m_82434_();
                            if (!modifiers.isEmpty()) {
                                BreakSpeedContext.Direct context = new BreakSpeedContext.Direct((Player)owner, state, pos, sideHit, true, miningSpeed, multiplier);
                                for (ModifierEntry entry : tool.getModifiers()) {
                                    miningSpeed = entry.getHook(ModifierHooks.BREAK_SPEED).modifyBreakSpeed(tool, entry, context, miningSpeed);
                                }
                            }
                        }
                        if ((double)miningSpeed > 1.5 * (double)hardness) {
                            ItemStack mainhand = owner.m_21205_();
                            owner.m_21008_(InteractionHand.MAIN_HAND, this.f_37555_);
                            int harvested = ToolHarvestLogic.runBlockBreak(this.f_37555_, tool, state, pos, result.m_82434_(), owner, (Projectile)this);
                            owner.m_21008_(InteractionHand.MAIN_HAND, mainhand);
                            if (harvested > 0) {
                                this.f_37556_ = true;
                                this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
                                if (!level.f_46443_) {
                                    this.f_19804_.m_276349_(STACK, (Object)this.f_37555_, true);
                                }
                                return;
                            }
                        }
                    }
                }
            }
        }
        super.m_8060_(result);
    }

    private boolean addToInventory(Player player) {
        ItemStack pickup = this.m_7941_();
        Inventory inventory = player.m_150109_();
        if (this.originalSlot != -1) {
            ItemStack current = inventory.m_8020_(this.originalSlot);
            if (current.m_41619_()) {
                inventory.m_6836_(this.originalSlot, pickup);
                return true;
            }
            if (current.m_41613_() < current.m_41741_() && ItemStack.m_150942_((ItemStack)current, (ItemStack)pickup)) {
                current.m_41769_(1);
                return true;
            }
        }
        return inventory.m_36054_(pickup);
    }

    protected boolean m_142470_(Player player) {
        return switch (this.f_36705_) {
            case AbstractArrow.Pickup.ALLOWED -> this.addToInventory(player);
            case AbstractArrow.Pickup.CREATIVE_ONLY -> player.m_150110_().f_35937_;
            default -> this.m_36797_() && this.m_150171_((Entity)player) && this.addToInventory(player);
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(WATER_INERTIA, (Object)Float.valueOf(0.6f));
    }

    @Override
    public ItemStack getDisplayTool() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_(KEY_CHARGE, this.charge);
        tag.m_128350_(KEY_MULTIPLIER, this.multiplier);
        tag.m_128350_(KEY_WATER_INERTIA, ((Float)this.f_19804_.m_135370_(WATER_INERTIA)).floatValue());
        tag.m_128379_(KEY_HIT_BLOCK, this.hitBlock);
        if (this.originalSlot != -1) {
            tag.m_128405_(KEY_ORIGINAL_SLOT, this.originalSlot);
        }
        if (!this.tasks.isEmpty()) {
            tag.m_128365_(KEY_TASKS, (Tag)this.tasks.serialize());
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Trident", 10)) {
            this.updateFromStack();
        }
        this.charge = tag.m_128457_(KEY_CHARGE);
        this.multiplier = tag.m_128457_(KEY_MULTIPLIER);
        this.f_19804_.m_135381_(WATER_INERTIA, (Object)Float.valueOf(tag.m_128457_(KEY_WATER_INERTIA)));
        this.hitBlock = tag.m_128471_(KEY_HIT_BLOCK);
        this.originalSlot = tag.m_128425_(KEY_ORIGINAL_SLOT, 99) ? tag.m_128451_(KEY_ORIGINAL_SLOT) : -1;
        if (tag.m_128425_(KEY_TASKS, 9)) {
            this.tasks = Schedule.deserialize(tag.m_128437_(KEY_TASKS, 10));
        }
    }

    public void setOriginalSlot(int originalSlot) {
        this.originalSlot = originalSlot;
    }
}

