/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractMultilevelModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.MultilevelModifierRecipe;

public class MultilevelModifierRecipeBuilder
extends AbstractMultilevelModifierRecipeBuilder<MultilevelModifierRecipeBuilder> {
    private final List<SizedIngredient> inputs = new ArrayList<SizedIngredient>();

    protected MultilevelModifierRecipeBuilder(ModifierId result) {
        super(result);
    }

    public static MultilevelModifierRecipeBuilder modifier(ModifierId result) {
        return new MultilevelModifierRecipeBuilder(result);
    }

    public MultilevelModifierRecipeBuilder addInput(SizedIngredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public MultilevelModifierRecipeBuilder addInput(Ingredient ingredient) {
        return this.addInput(SizedIngredient.of((Ingredient)ingredient));
    }

    public MultilevelModifierRecipeBuilder addInput(ItemLike item, int amount) {
        return this.addInput(SizedIngredient.fromItems((int)amount, (ItemLike[])new ItemLike[]{item}));
    }

    public MultilevelModifierRecipeBuilder addInput(ItemLike item) {
        return this.addInput(item, 1);
    }

    public MultilevelModifierRecipeBuilder addInput(TagKey<Item> tag, int amount) {
        return this.addInput(SizedIngredient.fromTag(tag, (int)amount));
    }

    public MultilevelModifierRecipeBuilder addInput(TagKey<Item> tag) {
        return this.addInput(tag, 1);
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.inputs.isEmpty() && !this.allowCrystal) {
            throw new IllegalStateException("Must either have at least 1 input or allow crystal");
        }
        if (this.levels.isEmpty()) {
            throw new IllegalStateException("Must have at least 1 level");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MultilevelModifierRecipe(id, this.inputs, this.tools, this.maxToolSize, this.result, this.allowCrystal, this.levels, this.checkTraitLevel), MultilevelModifierRecipe.LOADER, advancementId));
    }
}

