/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.ranged.common;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.GlowBlock;
import slimeknights.tconstruct.tools.TinkerTools;

public record ProjectilePlaceGlowModule(int damage, boolean blocks, boolean entities) implements ModifierModule,
ProjectileHitModifierHook,
ProjectileLaunchModifierHook
{
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.PROJECTILE_HIT, ModifierHooks.PROJECTILE_LAUNCH);
    public static final RecordLoadable<ProjectilePlaceGlowModule> LOADER = RecordLoadable.create((RecordField)IntLoadable.FROM_ZERO.requiredField("tool_damage", ProjectilePlaceGlowModule::damage), (RecordField)BooleanLoadable.INSTANCE.requiredField("blocks", ProjectilePlaceGlowModule::blocks), (RecordField)BooleanLoadable.INSTANCE.requiredField("entities", ProjectilePlaceGlowModule::entities), ProjectilePlaceGlowModule::new);

    public RecordLoadable<ProjectilePlaceGlowModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, ModDataNBT persistentData, boolean primary) {
        if (primary && this.damage > 0 && projectile.m_6095_() != TinkerTools.fishingHook.get()) {
            ToolDamageUtil.damageAnimated(tool, this.damage, shooter, shooter.m_7655_(), true);
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (this.entities) {
            ((GlowBlock)((Object)TinkerCommons.glow.get())).addGlow(projectile.m_9236_(), hit.m_82443_().m_20183_(), Direction.DOWN);
            if (this.damage > 0) {
                ModifierUtil.updateFishingRod(projectile, this.damage, false);
            }
        }
        return false;
    }

    @Override
    public boolean onProjectileHitsBlock(ModifierNBT modifiers, ModDataNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity owner) {
        if (this.blocks) {
            Direction direction = hit.m_82434_();
            if (((GlowBlock)((Object)TinkerCommons.glow.get())).addGlow(projectile.m_9236_(), hit.m_82425_().m_121945_(direction), direction.m_122424_()) && !projectile.m_6095_().m_204039_(TinkerTags.EntityTypes.REUSABLE_AMMO)) {
                ModifierUtil.updateFishingRod(projectile, this.damage, true);
                projectile.m_146870_();
            }
        }
        return false;
    }
}

