/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modules.interaction.sling;

import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.EntityInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InteractionSource;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingAngleModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingForceModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.special.sling.SlingLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.util.ModifierCondition;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableItem;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.modules.interaction.sling.SlingModule;

public record SlingKnockbackModule(float forceMultiplier, float drawtimeMultiplier, float damageMultiplier, IJsonPredicate<LivingEntity> target, ModifierCondition<IToolStackView> condition) implements SlingModule,
MeleeHitModifierHook,
MeleeDamageModifierHook
{
    private static final float RANGE = 5.0f;
    private static final List<ModuleHook<?>> DEFAULT_HOOKS = HookProvider.defaultHooks(ModifierHooks.GENERAL_INTERACT, ModifierHooks.TOOL_USING, ModifierHooks.MELEE_HIT, ModifierHooks.MELEE_DAMAGE);
    public static final RecordLoadable<SlingKnockbackModule> LOADER = RecordLoadable.create((RecordField)FORCE_FIELD, (RecordField)DRAWTIME_FIELD, (RecordField)FloatLoadable.FROM_ZERO.requiredField("damage_multiplier", SlingKnockbackModule::damageMultiplier), (RecordField)TARGET_FIELD, ModifierCondition.TOOL_FIELD, SlingKnockbackModule::new);
    public static final ResourceLocation IS_BONKING = TConstruct.getResource("is_bonking");

    public RecordLoadable<SlingKnockbackModule> getLoader() {
        return LOADER;
    }

    @Override
    public List<ModuleHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        if (tool.getPersistentData().getBoolean(IS_BONKING)) {
            return 0.0f;
        }
        return knockback;
    }

    @Override
    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        if (this.damageMultiplier != 1.0f && tool.getPersistentData().getBoolean(IS_BONKING)) {
            damage *= this.damageMultiplier;
        }
        return damage;
    }

    @Override
    public InteractionResult onToolUse(IToolStackView tool, ModifierEntry modifier, Player player, InteractionHand hand, InteractionSource source) {
        if (!tool.isBroken() && source == InteractionSource.RIGHT_CLICK && this.condition.matches(tool, modifier)) {
            float speed = ConditionalStatModifierHook.getModifiedStat(tool, (LivingEntity)player, ToolStats.DRAW_SPEED);
            if (tool.hasTag(TinkerTags.Items.MELEE_WEAPON)) {
                speed *= tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue();
            }
            tool.getPersistentData().putInt(GeneralInteractionModifierHook.KEY_DRAWTIME, (int)Math.ceil(20.0f * this.drawtimeMultiplier / speed));
            GeneralInteractionModifierHook.startUsing(tool, modifier.getId(), (LivingEntity)player, hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void beforeReleaseUsing(IToolStackView tool, ModifierEntry modifier, LivingEntity entity, int useDuration, int timeLeft, ModifierEntry activeModifier) {
        Level level = entity.m_9236_();
        if (!level.f_46443_ && this.condition.matches(tool, modifier) && entity instanceof Player) {
            Player player = (Player)entity;
            float charge = this.getCharge(tool, modifier, timeLeft);
            if (charge > 0.0f) {
                LivingEntity target;
                AABB bb;
                Vec3 start = player.m_20299_(1.0f);
                Vec3 look = player.m_20154_();
                Vec3 direction = start.m_82520_(look.f_82479_ * 5.0, look.f_82480_ * 5.0, look.f_82481_ * 5.0);
                EntityHitResult hit = ProjectileUtil.m_37304_((Level)level, (Entity)player, (Vec3)start, (Vec3)direction, (AABB)(bb = player.m_20191_().m_82363_(look.f_82479_ * 5.0, look.f_82480_ * 5.0, look.f_82481_ * 5.0).m_82363_(1.0, 1.0, 1.0)), e -> e instanceof LivingEntity);
                if (hit != null && this.target.matches((Object)(target = (LivingEntity)hit.m_82443_()))) {
                    double targetDist = start.m_82557_(target.m_20299_(1.0f));
                    BlockHitResult mop = ModifiableItem.blockRayTrace(level, player, ClipContext.Fluid.NONE);
                    if (mop.m_6662_() != HitResult.Type.BLOCK || targetDist < mop.m_82425_().m_203193_((Position)start)) {
                        boolean didBonk = false;
                        if (this.damageMultiplier > 0.0f && ToolAttackUtil.isAttackable(entity, (Entity)target) && tool.hasTag(TinkerTags.Items.MELEE) && !tool.getVolatileData().getBoolean(EntityInteractionModifierHook.NO_MELEE)) {
                            didBonk = true;
                            ModDataNBT data = tool.getPersistentData();
                            data.putBoolean(IS_BONKING, true);
                            InteractionHand hand = player.m_7655_();
                            ToolAttackContext.Builder builder = ToolAttackContext.attacker(entity).target(target).hand(hand).cooldown(Math.min(1.0f, charge)).extraAttack();
                            if (hand == InteractionHand.MAIN_HAND) {
                                builder.applyAttributes();
                            } else {
                                builder.toolAttributes(tool);
                            }
                            ToolAttackUtil.performAttack(tool, builder.build());
                            data.remove(IS_BONKING);
                        }
                        float inaccuracy = ModifierUtil.getInaccuracy(tool, (LivingEntity)player) * 0.0075f;
                        RandomSource random = player.m_217043_();
                        float multiplier = charge * this.forceMultiplier;
                        float force = SlingForceModifierHook.modifySlingForce(tool, entity, target, modifier, SlingModule.getPower(tool, (LivingEntity)player) * multiplier, multiplier);
                        Vec3 angle = Vec3.f_82478_;
                        if (force > 0.0f) {
                            angle = SlingAngleModifierHook.modifySlingAngle(tool, entity, target, modifier, force, multiplier, new Vec3(-look.f_82479_ + random.m_188583_() * (double)inaccuracy, 0.0, -look.f_82481_ + random.m_188583_() * (double)inaccuracy));
                            target.m_147240_((double)force, angle.f_82479_, angle.f_82481_);
                            if (target instanceof ServerPlayer) {
                                ServerPlayer playerMP = (ServerPlayer)target;
                                TinkerNetwork.getInstance().sendVanillaPacket((Packet)new ClientboundSetEntityMotionPacket((Entity)target), (Entity)playerMP);
                            }
                            didBonk = true;
                        }
                        if (didBonk) {
                            ToolAttackUtil.spawnAttackParticle((ParticleOptions)TinkerTools.bonkAttackParticle.get(), (Entity)player, 0.6);
                            SlingLaunchModifierHook.afterSlingLaunch(tool, entity, target, modifier, force, multiplier, angle);
                            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.BONK.getSound(), player.m_5720_(), 1.0f, 0.5f);
                            player.m_36399_(0.2f);
                            player.m_36335_().m_41524_(tool.getItem(), 3);
                            ToolDamageUtil.damageAnimated(tool, 1, entity);
                            return;
                        }
                    }
                }
            }
            if (ModifierUtil.isActiveModifier(tool, modifier, activeModifier)) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), Sounds.BONK.getSound(), player.m_5720_(), 1.0f, 1.0f);
            }
        }
    }
}

