/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client.material;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.FishingHookRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.client.armor.texture.TintedArmorTexture;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfo;
import slimeknights.tconstruct.library.client.materials.MaterialRenderInfoLoader;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.utils.SimpleCache;
import slimeknights.tconstruct.tools.entity.CombatFishingHook;

public class CombatFishingHookRenderer
extends EntityRenderer<CombatFishingHook> {
    private static final ResourceLocation LOCAL = TConstruct.getResource("fishing_hook/material");
    private static final ResourceLocation BASE = ArmorTextureSupplier.getTexturePath(LOCAL);
    private static final SimpleCache<MaterialVariantId, MaterialTexture> TEXTURE_CACHE = new SimpleCache<MaterialVariantId, MaterialTexture>(material -> {
        if (!IMaterial.UNKNOWN_ID.equals(material)) {
            Optional<MaterialRenderInfo> infoOptional = MaterialRenderInfoLoader.INSTANCE.getRenderInfo((MaterialVariantId)material);
            int color = -1;
            int luminosity = 0;
            if (infoOptional.isPresent()) {
                ResourceLocation texture;
                MaterialRenderInfo info = infoOptional.get();
                ResourceLocation untinted = info.texture();
                luminosity = info.luminosity();
                if (untinted != null && (texture = CombatFishingHookRenderer.tryTexture("_" + untinted.m_135827_() + "_" + untinted.m_135815_())) != null) {
                    return new MaterialTexture(texture, -1, luminosity);
                }
                color = info.vertexColor();
                for (String fallback : info.fallbacks()) {
                    ResourceLocation texture2 = CombatFishingHookRenderer.tryTexture("_" + fallback);
                    if (texture2 == null) continue;
                    return new MaterialTexture(texture2, color, luminosity);
                }
            }
            return new MaterialTexture(ArmorTextureSupplier.getTexturePath(LOCAL), color, luminosity);
        }
        return MaterialTexture.EMPTY;
    });

    @Nullable
    private static ResourceLocation tryTexture(String material) {
        ResourceLocation texture = LOCAL.m_266382_(material);
        if (ArmorTextureSupplier.TEXTURE_VALIDATOR.test(texture)) {
            return ArmorTextureSupplier.getTexturePath(texture);
        }
        return null;
    }

    public CombatFishingHookRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public static void clearCache() {
        TEXTURE_CACHE.clear();
    }

    public void render(CombatFishingHook hook, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Player player = hook.m_37168_();
        if (player != null) {
            float eyeHeight;
            double playerZo;
            double playerYo;
            double playerXo;
            poseStack.m_85836_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(this.f_114476_.m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            MaterialTexture texture = TEXTURE_CACHE.apply(hook.getMaterial());
            VertexConsumer consumer = buffer.m_6299_(texture.texture);
            int bobberLight = texture.applyLuminosity(packedLight);
            PoseStack.Pose lastPose = poseStack.m_85850_();
            Matrix4f pose = lastPose.m_252922_();
            Matrix3f normal = lastPose.m_252943_();
            texture.vertex(consumer, pose, normal, bobberLight, 0.0f, 0, 0, 1);
            texture.vertex(consumer, pose, normal, bobberLight, 1.0f, 0, 1, 1);
            texture.vertex(consumer, pose, normal, bobberLight, 1.0f, 1, 1, 0);
            texture.vertex(consumer, pose, normal, bobberLight, 0.0f, 1, 0, 0);
            poseStack.m_85849_();
            int sideOffset = player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.m_21205_();
            if (!itemstack.canPerformAction(ToolActions.FISHING_ROD_CAST)) {
                sideOffset = -sideOffset;
            }
            if (this.f_114476_.f_114360_.m_92176_().m_90612_() && player == Minecraft.m_91087_().f_91074_) {
                double fov = 960.0 / (double)((Integer)this.f_114476_.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 point = this.f_114476_.f_114358_.m_167684_().m_167695_((float)sideOffset * 0.525f, -0.1f);
                point = point.m_82490_(fov);
                float attackSin = Mth.m_14031_((float)(Mth.m_14116_((float)player.m_21324_(partialTicks)) * (float)Math.PI));
                point = point.m_82524_(attackSin * 0.5f);
                point = point.m_82496_(-attackSin * 0.7f);
                playerXo = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + point.f_82479_;
                playerYo = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + point.f_82480_;
                playerZo = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + point.f_82481_;
                eyeHeight = player.m_20192_();
            } else {
                float rotation = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
                double rotationSin = Mth.m_14031_((float)rotation);
                double rotationCos = Mth.m_14089_((float)rotation);
                double scaledSide = (double)sideOffset * 0.35;
                playerXo = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - rotationCos * scaledSide - rotationSin * 0.8;
                playerYo = player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                playerZo = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - rotationSin * scaledSide + rotationCos * 0.8;
                eyeHeight = player.m_6047_() ? -0.1875f : 0.0f;
            }
            float hookXOff = (float)(playerXo - Mth.m_14139_((double)partialTicks, (double)hook.f_19854_, (double)hook.m_20185_()));
            float hookYOff = (float)(playerYo - Mth.m_14139_((double)partialTicks, (double)hook.f_19855_, (double)hook.m_20186_()) - 0.25) + eyeHeight;
            float hookZOff = (float)(playerZo - Mth.m_14139_((double)partialTicks, (double)hook.f_19856_, (double)hook.m_20189_()));
            consumer = buffer.m_6299_(RenderType.m_173247_());
            lastPose = poseStack.m_85850_();
            for (int i = 0; i <= 16; ++i) {
                FishingHookRenderer.m_174118_((float)hookXOff, (float)hookYOff, (float)hookZOff, (VertexConsumer)consumer, (PoseStack.Pose)lastPose, (float)((float)i / 16.0f), (float)((float)(i + 1) / 16.0f));
            }
            poseStack.m_85849_();
            super.m_7392_((Entity)hook, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(CombatFishingHook pEntity) {
        return BASE;
    }

    private record MaterialTexture(RenderType texture, int luminosity, int alpha, int red, int green, int blue) {
        public static final MaterialTexture EMPTY = new MaterialTexture(BASE, -1, 0);

        public MaterialTexture(ResourceLocation texture, int color, int luminosity) {
            this(RenderType.m_110452_((ResourceLocation)texture), luminosity, color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF);
        }

        public int applyLuminosity(int packedLight) {
            if (this.luminosity > 0) {
                return TintedArmorTexture.applyLuminosity(packedLight, this.luminosity);
            }
            return packedLight;
        }

        public void vertex(VertexConsumer consumer, Matrix4f pose, Matrix3f normal, int lightmap, float pX, int pY, int pU, int pV) {
            consumer.m_252986_(pose, pX - 0.5f, (float)pY - 0.5f, 0.0f).m_6122_(this.red, this.green, this.blue, this.alpha).m_7421_((float)pU, (float)pV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        }
    }
}

